/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.index;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="1.0.0")
public class IndexResponse
extends DocWriteResponse {
    public IndexResponse(ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
    }

    public IndexResponse(StreamInput in) throws IOException {
        super(in);
    }

    public IndexResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, boolean created) {
        this(shardId, id, seqNo, primaryTerm, version, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED);
    }

    private IndexResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        super(shardId, id, seqNo, primaryTerm, version, IndexResponse.assertCreatedOrUpdated(result));
    }

    private static DocWriteResponse.Result assertCreatedOrUpdated(DocWriteResponse.Result result) {
        assert (result == DocWriteResponse.Result.CREATED || result == DocWriteResponse.Result.UPDATED);
        return result;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",seqNo=").append(this.getSeqNo());
        builder.append(",primaryTerm=").append(this.getPrimaryTerm());
        builder.append(",shards=").append(Strings.toString(MediaTypeRegistry.JSON, this.getShardInfo()));
        return builder.append("]").toString();
    }

    public static IndexResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        Builder context = new Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            IndexResponse.parseXContentFields(parser, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser, Builder context) throws IOException {
        DocWriteResponse.parseInnerToXContent(parser, context);
    }

    @PublicApi(since="1.0.0")
    public static class Builder
    extends DocWriteResponse.Builder {
        @Override
        public IndexResponse build() {
            IndexResponse indexResponse = new IndexResponse(this.shardId, this.id, this.seqNo, this.primaryTerm, (long)this.version, this.result);
            indexResponse.setForcedRefresh(this.forcedRefresh);
            if (this.shardInfo != null) {
                indexResponse.setShardInfo(this.shardInfo);
            }
            return indexResponse;
        }
    }
}

