/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;
import org.opensearch.client.ReactiveDataProducer;
import org.reactivestreams.Publisher;

class ReactiveRequestProducer
implements HttpAsyncRequestProducer {
    private final HttpHost target;
    private final HttpRequest request;
    private final ReactiveDataProducer producer;

    ReactiveRequestProducer(HttpRequest request, HttpHost target, Publisher<ByteBuffer> publisher) {
        this.target = target;
        this.request = request;
        this.producer = new ReactiveDataProducer(publisher);
    }

    @Override
    public HttpRequest generateRequest() {
        Header contentTypeHeader = this.request.getFirstHeader("Content-Type");
        if (contentTypeHeader == null) {
            this.request.setHeader(new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()));
        }
        if (this.request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)this.request;
            enclosingRequest.setEntity(new ReactiveHttpEntity(this.request.getFirstHeader("Content-Type"), this.request.getFirstHeader("Content-Encoding")));
        }
        return this.request;
    }

    @Override
    public HttpHost getTarget() {
        return this.target;
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(encoder, ioControl);
            if (encoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    @Override
    public void requestCompleted(HttpContext context) {
        this.producer.onComplete();
    }

    @Override
    public void failed(Exception ex) {
        this.producer.onError(ex);
    }

    @Override
    public boolean isRepeatable() {
        return this.producer.isRepeatable();
    }

    @Override
    public void resetRequest() throws IOException {
        this.producer.close();
    }

    @Override
    public void close() throws IOException {
        this.producer.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.target);
        sb.append(' ');
        sb.append(this.request);
        if (this.producer != null) {
            sb.append(' ');
            sb.append(this.producer);
        }
        return sb.toString();
    }

    private static final class ReactiveHttpEntity
    implements HttpEntity {
        private final Header contentType;
        private final Header contentEncoding;

        private ReactiveHttpEntity(Header contentType, Header contentEncoding) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
        }

        @Override
        public void writeTo(OutputStream outStream) throws IOException {
            throw new UnsupportedOperationException("This operation is not supported");
        }

        @Override
        public boolean isStreaming() {
            return true;
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public boolean isChunked() {
            return true;
        }

        @Override
        public Header getContentType() {
            return this.contentType;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Header getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public InputStream getContent() throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("This operation is not supported");
        }

        @Override
        public void consumeContent() throws IOException {
            throw new UnsupportedOperationException("This operation is not supported");
        }
    }
}

