/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.slm;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.client.slm.SnapshotInvocationRecord;
import org.opensearch.client.slm.SnapshotLifecyclePolicy;
import org.opensearch.client.slm.SnapshotLifecycleStats;
import org.opensearch.common.Nullable;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.snapshots.SnapshotId;

public class SnapshotLifecyclePolicyMetadata
implements ToXContentObject {
    static final ParseField POLICY = new ParseField("policy", new String[0]);
    static final ParseField VERSION = new ParseField("version", new String[0]);
    static final ParseField MODIFIED_DATE_MILLIS = new ParseField("modified_date_millis", new String[0]);
    static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    static final ParseField LAST_SUCCESS = new ParseField("last_success", new String[0]);
    static final ParseField LAST_FAILURE = new ParseField("last_failure", new String[0]);
    static final ParseField NEXT_EXECUTION_MILLIS = new ParseField("next_execution_millis", new String[0]);
    static final ParseField NEXT_EXECUTION = new ParseField("next_execution", new String[0]);
    static final ParseField SNAPSHOT_IN_PROGRESS = new ParseField("in_progress", new String[0]);
    static final ParseField POLICY_STATS = new ParseField("stats", new String[0]);
    private final SnapshotLifecyclePolicy policy;
    private final long version;
    private final long modifiedDate;
    private final long nextExecution;
    @Nullable
    private final SnapshotInvocationRecord lastSuccess;
    @Nullable
    private final SnapshotInvocationRecord lastFailure;
    @Nullable
    private final SnapshotInProgress snapshotInProgress;
    private final SnapshotLifecycleStats.SnapshotPolicyStats policyStats;
    public static final ConstructingObjectParser<SnapshotLifecyclePolicyMetadata, String> PARSER = new ConstructingObjectParser("snapshot_policy_metadata", a -> {
        SnapshotLifecyclePolicy policy = (SnapshotLifecyclePolicy)a[0];
        long version = (Long)a[1];
        long modifiedDate = (Long)a[2];
        SnapshotInvocationRecord lastSuccess = (SnapshotInvocationRecord)a[3];
        SnapshotInvocationRecord lastFailure = (SnapshotInvocationRecord)a[4];
        long nextExecution = (Long)a[5];
        SnapshotInProgress sip = (SnapshotInProgress)a[6];
        SnapshotLifecycleStats.SnapshotPolicyStats stats = (SnapshotLifecycleStats.SnapshotPolicyStats)a[7];
        return new SnapshotLifecyclePolicyMetadata(policy, version, modifiedDate, lastSuccess, lastFailure, nextExecution, sip, stats);
    });

    public static SnapshotLifecyclePolicyMetadata parse(XContentParser parser, String id) {
        return PARSER.apply(parser, id);
    }

    public SnapshotLifecyclePolicyMetadata(SnapshotLifecyclePolicy policy, long version, long modifiedDate, SnapshotInvocationRecord lastSuccess, SnapshotInvocationRecord lastFailure, long nextExecution, @Nullable SnapshotInProgress snapshotInProgress, SnapshotLifecycleStats.SnapshotPolicyStats policyStats) {
        this.policy = policy;
        this.version = version;
        this.modifiedDate = modifiedDate;
        this.lastSuccess = lastSuccess;
        this.lastFailure = lastFailure;
        this.nextExecution = nextExecution;
        this.snapshotInProgress = snapshotInProgress;
        this.policyStats = policyStats;
    }

    public SnapshotLifecyclePolicy getPolicy() {
        return this.policy;
    }

    public String getName() {
        return this.policy.getName();
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public SnapshotInvocationRecord getLastSuccess() {
        return this.lastSuccess;
    }

    public SnapshotInvocationRecord getLastFailure() {
        return this.lastFailure;
    }

    public long getNextExecution() {
        return this.nextExecution;
    }

    public SnapshotLifecycleStats.SnapshotPolicyStats getPolicyStats() {
        return this.policyStats;
    }

    @Nullable
    public SnapshotInProgress getSnapshotInProgress() {
        return this.snapshotInProgress;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY.getPreferredName(), this.policy);
        builder.field(VERSION.getPreferredName(), this.version);
        builder.timeField(MODIFIED_DATE_MILLIS.getPreferredName(), MODIFIED_DATE.getPreferredName(), this.modifiedDate);
        if (Objects.nonNull(this.lastSuccess)) {
            builder.field(LAST_SUCCESS.getPreferredName(), this.lastSuccess);
        }
        if (Objects.nonNull(this.lastFailure)) {
            builder.field(LAST_FAILURE.getPreferredName(), this.lastFailure);
        }
        builder.timeField(NEXT_EXECUTION_MILLIS.getPreferredName(), NEXT_EXECUTION.getPreferredName(), this.nextExecution);
        if (this.snapshotInProgress != null) {
            builder.field(SNAPSHOT_IN_PROGRESS.getPreferredName(), this.snapshotInProgress);
        }
        builder.startObject(POLICY_STATS.getPreferredName());
        this.policyStats.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.version, this.modifiedDate, this.lastSuccess, this.lastFailure, this.nextExecution, this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotLifecyclePolicyMetadata other = (SnapshotLifecyclePolicyMetadata)obj;
        return Objects.equals(this.policy, other.policy) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate) && Objects.equals(this.lastSuccess, other.lastSuccess) && Objects.equals(this.lastFailure, other.lastFailure) && Objects.equals(this.nextExecution, other.nextExecution) && Objects.equals(this.policyStats, other.policyStats);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), SnapshotLifecyclePolicy::parse, POLICY);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODIFIED_DATE_MILLIS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SnapshotInvocationRecord::parse, LAST_SUCCESS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SnapshotInvocationRecord::parse, LAST_FAILURE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NEXT_EXECUTION_MILLIS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (x$0, x$1) -> SnapshotInProgress.parse(x$0, x$1), SNAPSHOT_IN_PROGRESS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SnapshotLifecycleStats.SnapshotPolicyStats.parse(p, "policy"), POLICY_STATS);
    }

    public static class SnapshotInProgress
    implements ToXContentObject {
        private static final ParseField NAME = new ParseField("name", new String[0]);
        private static final ParseField UUID = new ParseField("uuid", new String[0]);
        private static final ParseField STATE = new ParseField("state", new String[0]);
        private static final ParseField START_TIME = new ParseField("start_time_millis", new String[0]);
        private static final ParseField FAILURE = new ParseField("failure", new String[0]);
        private static final ConstructingObjectParser<SnapshotInProgress, Void> PARSER = new ConstructingObjectParser("snapshot_in_progress", true, a -> {
            SnapshotId id = new SnapshotId((String)a[0], (String)a[1]);
            String state = (String)a[2];
            long start = (Long)a[3];
            String failure = (String)a[4];
            return new SnapshotInProgress(id, state, start, failure);
        });
        private final SnapshotId snapshotId;
        private final String state;
        private final long startTime;
        private final String failure;

        public SnapshotInProgress(SnapshotId snapshotId, String state, long startTime, @Nullable String failure) {
            this.snapshotId = snapshotId;
            this.state = state;
            this.startTime = startTime;
            this.failure = failure;
        }

        private static SnapshotInProgress parse(XContentParser parser, String name) {
            return PARSER.apply(parser, null);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME.getPreferredName(), this.snapshotId.getName());
            builder.field(UUID.getPreferredName(), this.snapshotId.getUUID());
            builder.field(STATE.getPreferredName(), this.state);
            builder.timeField(START_TIME.getPreferredName(), "start_time", this.startTime);
            if (this.failure != null) {
                builder.field(FAILURE.getPreferredName(), this.failure);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.snapshotId, this.state, this.startTime, this.failure);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SnapshotInProgress other = (SnapshotInProgress)obj;
            return Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.state, other.state) && this.startTime == other.startTime && Objects.equals(this.failure, other.failure);
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), UUID);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), STATE);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), START_TIME);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FAILURE);
        }
    }
}

