/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.applicationtemplates;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchCorruptionException;
import org.opensearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.opensearch.client.Client;
import org.opensearch.client.OriginSettingClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.applicationtemplates.SystemTemplate;
import org.opensearch.cluster.applicationtemplates.SystemTemplateLoader;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public class ClusterStateSystemTemplateLoader
implements SystemTemplateLoader {
    private final Client client;
    private final Supplier<ClusterState> clusterStateSupplier;
    private static final Logger logger = LogManager.getLogger(SystemTemplateLoader.class);
    public static final String TEMPLATE_LOADER_IDENTIFIER = "system_template_loader";
    public static final String TEMPLATE_TYPE_KEY = "_type";

    public ClusterStateSystemTemplateLoader(Client client, Supplier<ClusterState> clusterStateSupplier) {
        this.client = new OriginSettingClient(client, TEMPLATE_LOADER_IDENTIFIER);
        this.clusterStateSupplier = clusterStateSupplier;
    }

    @Override
    public boolean loadTemplate(SystemTemplate template) throws IOException {
        ComponentTemplate existingTemplate = this.clusterStateSupplier.get().metadata().componentTemplates().get(template.templateMetadata().fullyQualifiedName());
        if (existingTemplate != null && !"@abc_template".equals(Objects.toString(existingTemplate.metadata().get(TEMPLATE_TYPE_KEY)))) {
            throw new OpenSearchCorruptionException("Attempting to create " + template.templateMetadata().name() + " which has already been created through some other source.");
        }
        if (existingTemplate != null && existingTemplate.version() >= template.templateMetadata().version()) {
            logger.debug("Skipping putting template {} as its existing version [{}] is >= fetched version [{}]", (Object)template.templateMetadata().fullyQualifiedName(), (Object)existingTemplate.version(), (Object)template.templateMetadata().version());
            return false;
        }
        ComponentTemplate newTemplate = null;
        try (XContentParser contentParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, template.templateContent().utf8ToString());){
            newTemplate = ComponentTemplate.parse(contentParser);
        }
        if (!Objects.equals(newTemplate.version(), template.templateMetadata().version())) {
            throw new OpenSearchCorruptionException("Template version mismatch for " + template.templateMetadata().name() + ". Version in metadata: " + template.templateMetadata().version() + " , Version in content: " + newTemplate.version());
        }
        PutComponentTemplateAction.Request request = new PutComponentTemplateAction.Request(template.templateMetadata().fullyQualifiedName()).componentTemplate(newTemplate);
        return this.client.admin().indices().execute(PutComponentTemplateAction.INSTANCE, request).actionGet(TimeValue.timeValueMillis(30000L)).isAcknowledged();
    }
}

