/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service;

import java.io.IOException;
import org.opensearch.common.Priority;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.text.Text;

@PublicApi(since="1.0.0")
public class PendingClusterTask
implements Writeable {
    private long insertOrder;
    private Priority priority;
    private Text source;
    private long timeInQueue;
    private boolean executing;

    public PendingClusterTask(StreamInput in) throws IOException {
        this.insertOrder = in.readVLong();
        this.priority = Priority.readFrom(in);
        this.source = in.readText();
        this.timeInQueue = in.readLong();
        this.executing = in.readBoolean();
    }

    public PendingClusterTask(long insertOrder, Priority priority, Text source, long timeInQueue, boolean executing) {
        assert (timeInQueue >= 0L) : "got a negative timeInQueue [" + timeInQueue + "]";
        assert (insertOrder >= 0L) : "got a negative insertOrder [" + insertOrder + "]";
        this.insertOrder = insertOrder;
        this.priority = priority;
        this.source = source;
        this.timeInQueue = timeInQueue;
        this.executing = executing;
    }

    public long getInsertOrder() {
        return this.insertOrder;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Text getSource() {
        return this.source;
    }

    public long getTimeInQueueInMillis() {
        return this.timeInQueue;
    }

    public TimeValue getTimeInQueue() {
        return new TimeValue(this.getTimeInQueueInMillis());
    }

    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.insertOrder);
        Priority.writeTo(this.priority, out);
        out.writeText(this.source);
        out.writeLong(this.timeInQueue);
        out.writeBoolean(this.executing);
    }
}

