/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ThreadContextStatePropagator;
import org.opensearch.common.util.concurrent.WrappedRunnable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.secure_sm.ThreadContextPermission;
import org.opensearch.tasks.TaskThreadContextStatePropagator;

@PublicApi(since="1.0.0")
public final class ThreadContext
implements Writeable {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ThreadContext.class);
    public static final String PREFIX = "request.headers";
    public static final Setting<Settings> DEFAULT_HEADERS_SETTING = Setting.groupSetting("request.headers.", Setting.Property.NodeScope);
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    private static final Permission ACCESS_SYSTEM_THREAD_CONTEXT_PERMISSION = new ThreadContextPermission("markAsSystemContext");
    private static final Permission STASH_AND_MERGE_THREAD_CONTEXT_PERMISSION = new ThreadContextPermission("stashAndMergeHeaders");
    private static final Permission STASH_WITH_ORIGIN_THREAD_CONTEXT_PERMISSION = new ThreadContextPermission("stashWithOrigin");
    private static final Logger logger = LogManager.getLogger(ThreadContext.class);
    private static final ThreadContextStruct DEFAULT_CONTEXT = new ThreadContextStruct();
    private final Map<String, String> defaultHeader;
    private final ThreadLocal<ThreadContextStruct> threadLocal;
    private final int maxWarningHeaderCount;
    private final long maxWarningHeaderSize;
    private final List<ThreadContextStatePropagator> propagators;
    private static final Collector<String, Set<String>, Set<String>> LINKED_HASH_SET_COLLECTOR = new LinkedHashSetCollector<String>();

    public ThreadContext(Settings settings) {
        this.defaultHeader = ThreadContext.buildDefaultHeaders(settings);
        this.threadLocal = ThreadLocal.withInitial(() -> DEFAULT_CONTEXT);
        this.maxWarningHeaderCount = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_COUNT.get(settings);
        this.maxWarningHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.get(settings).getBytes();
        this.propagators = new CopyOnWriteArrayList<TaskThreadContextStatePropagator>(List.of(new TaskThreadContextStatePropagator()));
    }

    public void registerThreadContextStatePropagator(ThreadContextStatePropagator propagator) {
        this.propagators.add(Objects.requireNonNull(propagator));
    }

    public void unregisterThreadContextStatePropagator(ThreadContextStatePropagator propagator) {
        this.propagators.remove(Objects.requireNonNull(propagator));
    }

    public StoredContext stashContext() {
        Map<String, Object> transientHeaders;
        ThreadContextStruct context = this.threadLocal.get();
        ThreadContextStruct threadContextStruct = DEFAULT_CONTEXT.putPersistent(context.persistentHeaders);
        if (context.requestHeaders.containsKey("X-Opaque-Id")) {
            threadContextStruct = threadContextStruct.putHeaders(MapBuilder.newMapBuilder().put("X-Opaque-Id", context.requestHeaders.get("X-Opaque-Id")).immutableMap());
        }
        if (!(transientHeaders = this.propagateTransients(context.transientHeaders, context.isSystemContext)).isEmpty()) {
            threadContextStruct = threadContextStruct.putTransient(transientHeaders);
        }
        this.threadLocal.set(threadContextStruct);
        return () -> this.threadLocal.set(context);
    }

    public Writeable captureAsWriteable() {
        ThreadContextStruct context = this.threadLocal.get();
        return out -> {
            Map<String, String> propagatedHeaders = this.propagateHeaders(context.transientHeaders, context.isSystemContext);
            context.writeTo(out, this.defaultHeader, propagatedHeaders);
        };
    }

    public StoredContext stashWithOrigin(String origin) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(STASH_WITH_ORIGIN_THREAD_CONTEXT_PERMISSION);
            }
            catch (SecurityException ex) {
                deprecationLogger.deprecate("stashWithOrigin", "Default access to stashWithOrigin will be removed in a future release. Permission to use stashWithOrigin must be explicitly granted.", new Object[0]);
            }
        }
        StoredContext storedContext = this.stashContext();
        this.putTransient(ACTION_ORIGIN_TRANSIENT_NAME, origin);
        return storedContext;
    }

    public StoredContext stashAndMergeHeaders(Map<String, String> headers) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(STASH_AND_MERGE_THREAD_CONTEXT_PERMISSION);
            }
            catch (SecurityException ex) {
                deprecationLogger.deprecate("stashAndMergeHeaders", "Default access to stashAndMergeHeaders will be removed in a future release. Permission to use stashAndMergeHeaders must be explicitly granted.", new Object[0]);
            }
        }
        ThreadContextStruct context = this.threadLocal.get();
        HashMap<String, String> newHeader = new HashMap<String, String>(headers);
        newHeader.putAll(context.requestHeaders);
        this.threadLocal.set(DEFAULT_CONTEXT.putHeaders(newHeader));
        return () -> this.threadLocal.set(context);
    }

    public StoredContext newStoredContext(boolean preserveResponseHeaders) {
        return this.newStoredContext(preserveResponseHeaders, Collections.emptyList());
    }

    public StoredContext newStoredContext(boolean preserveResponseHeaders, Collection<String> transientHeadersToClear) {
        ThreadContextStruct originalContext = this.threadLocal.get();
        HashMap<String, Object> newTransientHeaders = new HashMap<String, Object>(originalContext.transientHeaders);
        boolean transientHeadersModified = false;
        Map<String, Object> transientHeaders = this.propagateTransients(originalContext.transientHeaders, originalContext.isSystemContext);
        if (!transientHeaders.isEmpty()) {
            newTransientHeaders.putAll(transientHeaders);
            transientHeadersModified = true;
        }
        for (String transientHeaderToClear : transientHeadersToClear) {
            if (!newTransientHeaders.containsKey(transientHeaderToClear)) continue;
            newTransientHeaders.remove(transientHeaderToClear);
            transientHeadersModified = true;
        }
        if (transientHeadersModified) {
            ThreadContextStruct threadContextStruct = new ThreadContextStruct(originalContext.requestHeaders, originalContext.responseHeaders, newTransientHeaders, originalContext.persistentHeaders, originalContext.isSystemContext, originalContext.warningHeadersSize);
            this.threadLocal.set(threadContextStruct);
        }
        ThreadContextStruct newContext = this.threadLocal.get();
        return () -> {
            if (preserveResponseHeaders && this.threadLocal.get() != newContext) {
                this.threadLocal.set(originalContext.putResponseHeaders(this.threadLocal.get().responseHeaders));
            } else {
                this.threadLocal.set(originalContext);
            }
        };
    }

    public Supplier<StoredContext> newRestorableContext(boolean preserveResponseHeaders) {
        return this.wrapRestorable(this.newStoredContext(preserveResponseHeaders));
    }

    public Supplier<StoredContext> wrapRestorable(StoredContext storedContext) {
        return () -> {
            StoredContext context = this.newStoredContext(false);
            storedContext.restore();
            return context;
        };
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ThreadContextStruct context = this.threadLocal.get();
        Map<String, String> propagatedHeaders = this.propagateHeaders(context.transientHeaders, context.isSystemContext);
        context.writeTo(out, this.defaultHeader, propagatedHeaders);
    }

    public void readHeaders(StreamInput in) throws IOException {
        this.setHeaders(ThreadContext.readHeadersFromStream(in));
    }

    public void setHeaders(Tuple<Map<String, String>, Map<String, Set<String>>> headerTuple) {
        Map<String, String> requestHeaders = headerTuple.v1();
        Map<String, Set<String>> responseHeaders = headerTuple.v2();
        ThreadContextStruct struct = requestHeaders.isEmpty() && responseHeaders.isEmpty() ? ThreadContextStruct.EMPTY : new ThreadContextStruct(requestHeaders, responseHeaders, Collections.emptyMap(), Collections.emptyMap(), false);
        this.threadLocal.set(struct);
    }

    public static Tuple<Map<String, String>, Map<String, Set<String>>> readHeadersFromStream(StreamInput in) throws IOException {
        Map<String, String> requestHeaders = in.readMap(StreamInput::readString, StreamInput::readString);
        Map<String, Set> responseHeaders = in.readMap(StreamInput::readString, input -> {
            int size = input.readVInt();
            if (size == 0) {
                return Collections.emptySet();
            }
            if (size == 1) {
                return Collections.singleton(input.readString());
            }
            LinkedHashSet<String> values = new LinkedHashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                String value = input.readString();
                boolean added = values.add(value);
                assert (added) : value;
            }
            return values;
        });
        return new Tuple<Map<String, String>, Map<String, Set<String>>>(requestHeaders, responseHeaders);
    }

    public String getHeader(String key) {
        String value = this.threadLocal.get().requestHeaders.get(key);
        if (value == null) {
            return this.defaultHeader.get(key);
        }
        return value;
    }

    public Object getPersistent(String key) {
        return this.threadLocal.get().persistentHeaders.get(key);
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>(this.defaultHeader);
        map.putAll(this.threadLocal.get().requestHeaders);
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getRequestHeadersOnly() {
        return Collections.unmodifiableMap(new HashMap<String, String>(this.threadLocal.get().requestHeaders));
    }

    public Map<String, List<String>> getResponseHeaders() {
        Map<String, Set<String>> responseHeaders = this.threadLocal.get().responseHeaders;
        HashMap map = new HashMap(responseHeaders.size());
        for (Map.Entry<String, Set<String>> entry : responseHeaders.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
        }
        return Collections.unmodifiableMap(map);
    }

    public void copyHeaders(Iterable<Map.Entry<String, String>> headers) {
        this.threadLocal.set(this.threadLocal.get().copyHeaders(headers));
    }

    public void putHeader(String key, String value) {
        this.threadLocal.set(this.threadLocal.get().putRequest(key, value));
    }

    public void putHeader(Map<String, String> header) {
        this.threadLocal.set(this.threadLocal.get().putHeaders(header));
    }

    public void putPersistent(String key, Object value) {
        this.threadLocal.set(this.threadLocal.get().putPersistent(key, value));
    }

    public void putPersistent(Map<String, Object> persistentHeaders) {
        this.threadLocal.set(this.threadLocal.get().putPersistent(persistentHeaders));
    }

    public void putTransient(String key, Object value) {
        this.threadLocal.set(this.threadLocal.get().putTransient(key, value));
    }

    public <T> T getTransient(String key) {
        return (T)this.threadLocal.get().transientHeaders.get(key);
    }

    public void addResponseHeader(String key, String value) {
        this.addResponseHeader(key, value, v -> v);
    }

    public void updateResponseHeader(String key, String value) {
        this.updateResponseHeader(key, value, v -> v);
    }

    public void addResponseHeader(String key, String value, Function<String, String> uniqueValue) {
        this.threadLocal.set(this.threadLocal.get().putResponse(key, value, uniqueValue, this.maxWarningHeaderCount, this.maxWarningHeaderSize, false));
    }

    public void updateResponseHeader(String key, String value, Function<String, String> uniqueValue) {
        this.threadLocal.set(this.threadLocal.get().putResponse(key, value, uniqueValue, this.maxWarningHeaderCount, this.maxWarningHeaderSize, true));
    }

    public void removeResponseHeader(String key) {
        this.threadLocal.get().responseHeaders.remove(key);
    }

    public Runnable preserveContext(Runnable command) {
        if (command instanceof ContextPreservingAbstractRunnable) {
            return command;
        }
        if (command instanceof ContextPreservingRunnable) {
            return command;
        }
        if (command instanceof AbstractRunnable) {
            return new ContextPreservingAbstractRunnable((AbstractRunnable)command);
        }
        return new ContextPreservingRunnable(command);
    }

    public Runnable unwrap(Runnable command) {
        if (command instanceof WrappedRunnable) {
            return ((WrappedRunnable)command).unwrap();
        }
        return command;
    }

    boolean isDefaultContext() {
        return this.threadLocal.get() == DEFAULT_CONTEXT;
    }

    public void markAsSystemContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(ACCESS_SYSTEM_THREAD_CONTEXT_PERMISSION);
            }
            catch (SecurityException ex) {
                deprecationLogger.deprecate("markAsSystemContext", "Default access to markAsSystemContext will be removed in a future release. Permission to use markAsSystemContext must be explicitly granted.", new Object[0]);
            }
        }
        this.threadLocal.set(this.threadLocal.get().setSystemContext(this.propagators));
    }

    public boolean isSystemContext() {
        return this.threadLocal.get().isSystemContext;
    }

    public static Map<String, String> buildDefaultHeaders(Settings settings) {
        Settings headers = DEFAULT_HEADERS_SETTING.get(settings);
        if (headers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> defaultHeader = new HashMap<String, String>();
        for (String key : headers.names()) {
            defaultHeader.put(key, headers.get(key));
        }
        return Collections.unmodifiableMap(defaultHeader);
    }

    private Map<String, Object> propagateTransients(Map<String, Object> source, boolean isSystemContext) {
        HashMap<String, Object> transients = new HashMap<String, Object>();
        this.propagators.forEach(p -> transients.putAll(p.transients(source, isSystemContext)));
        return transients;
    }

    private Map<String, String> propagateHeaders(Map<String, Object> source, boolean isSystemContext) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.propagators.forEach(p -> headers.putAll(p.headers(source, isSystemContext)));
        return headers;
    }

    private static final class ThreadContextStruct {
        private static final ThreadContextStruct EMPTY = new ThreadContextStruct(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        private final Map<String, String> requestHeaders;
        private final Map<String, Object> transientHeaders;
        private final Map<String, Set<String>> responseHeaders;
        private final Map<String, Object> persistentHeaders;
        private final boolean isSystemContext;
        private final long warningHeadersSize;

        private ThreadContextStruct setSystemContext(List<ThreadContextStatePropagator> propagators) {
            if (this.isSystemContext) {
                return this;
            }
            HashMap<String, Object> transients = new HashMap<String, Object>();
            propagators.forEach(p -> transients.putAll(p.transients(this.transientHeaders, true)));
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, transients, this.persistentHeaders, true);
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, Set<String>> responseHeaders, Map<String, Object> transientHeaders, Map<String, Object> persistentHeaders, boolean isSystemContext) {
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
            this.transientHeaders = transientHeaders;
            this.persistentHeaders = persistentHeaders;
            this.isSystemContext = isSystemContext;
            this.warningHeadersSize = 0L;
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, Set<String>> responseHeaders, Map<String, Object> transientHeaders, Map<String, Object> persistentHeaders, boolean isSystemContext, long warningHeadersSize) {
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
            this.transientHeaders = transientHeaders;
            this.persistentHeaders = persistentHeaders;
            this.isSystemContext = isSystemContext;
            this.warningHeadersSize = warningHeadersSize;
        }

        private ThreadContextStruct() {
            this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        }

        private ThreadContextStruct putRequest(String key, String value) {
            HashMap<String, String> newRequestHeaders = new HashMap<String, String>(this.requestHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newRequestHeaders);
            return new ThreadContextStruct(newRequestHeaders, this.responseHeaders, this.transientHeaders, this.persistentHeaders, this.isSystemContext);
        }

        private static <T> void putSingleHeader(String key, T value, Map<String, T> newHeaders) {
            if (newHeaders.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("value for key [" + key + "] already present");
            }
        }

        private ThreadContextStruct putHeaders(Map<String, String> headers) {
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, String> newHeaders = new HashMap<String, String>(this.requestHeaders);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                ThreadContextStruct.putSingleHeader(entry.getKey(), entry.getValue(), newHeaders);
            }
            return new ThreadContextStruct(newHeaders, this.responseHeaders, this.transientHeaders, this.persistentHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putPersistent(String key, Object value) {
            HashMap<String, Object> newPersistentHeaders = new HashMap<String, Object>(this.persistentHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newPersistentHeaders);
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, newPersistentHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putPersistent(Map<String, Object> headers) {
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, Object> newPersistentHeaders = new HashMap<String, Object>(this.persistentHeaders);
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                ThreadContextStruct.putSingleHeader(entry.getKey(), entry.getValue(), newPersistentHeaders);
            }
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, newPersistentHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponseHeaders(Map<String, Set<String>> headers) {
            assert (headers != null);
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, Set<String>> newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
            for (Map.Entry<String, Set<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                Set existingValues = (Set)newResponseHeaders.get(key);
                if (existingValues != null) {
                    Set<String> newValues = Stream.concat(entry.getValue().stream(), existingValues.stream()).collect(LINKED_HASH_SET_COLLECTOR);
                    newResponseHeaders.put(key, Collections.unmodifiableSet(newValues));
                    continue;
                }
                newResponseHeaders.put(key, entry.getValue());
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.persistentHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponse(String key, String value, Function<String, String> uniqueValue, int maxWarningHeaderCount, long maxWarningHeaderSize, boolean replaceExistingKey) {
            HashMap<String, Set<String>> newResponseHeaders;
            Set<String> existingValues;
            assert (value != null);
            long newWarningHeaderSize = this.warningHeadersSize;
            if (key.equals("Warning") && maxWarningHeaderSize != -1L) {
                if (this.warningHeadersSize > maxWarningHeaderSize) {
                    logger.warn("Dropping a warning header, as their total size reached the maximum allowed of [" + maxWarningHeaderSize + "] bytes set in [" + HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.getKey() + "]!");
                    return this;
                }
                if ((newWarningHeaderSize += (long)("Warning".getBytes(StandardCharsets.UTF_8).length + value.getBytes(StandardCharsets.UTF_8).length)) > maxWarningHeaderSize) {
                    logger.warn("Dropping a warning header, as their total size reached the maximum allowed of [" + maxWarningHeaderSize + "] bytes set in [" + HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.getKey() + "]!");
                    return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, this.persistentHeaders, this.isSystemContext, newWarningHeaderSize);
                }
            }
            if ((existingValues = this.responseHeaders.get(key)) != null) {
                if (existingValues.contains(uniqueValue.apply(value))) {
                    return this;
                }
                Set<String> newValues = replaceExistingKey ? Stream.of(value).collect(LINKED_HASH_SET_COLLECTOR) : Stream.concat(existingValues.stream(), Stream.of(value)).collect(LINKED_HASH_SET_COLLECTOR);
                newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
                newResponseHeaders.put(key, Collections.unmodifiableSet(newValues));
            } else {
                newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
                newResponseHeaders.put(key, Collections.singleton(value));
            }
            if (key.equals("Warning") && maxWarningHeaderCount != -1) {
                int warningHeaderCount;
                int n = warningHeaderCount = newResponseHeaders.containsKey("Warning") ? ((Set)newResponseHeaders.get("Warning")).size() : 0;
                if (warningHeaderCount > maxWarningHeaderCount) {
                    logger.warn("Dropping a warning header, as their total count reached the maximum allowed of [" + maxWarningHeaderCount + "] set in [" + HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_COUNT.getKey() + "]!");
                    return this;
                }
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.persistentHeaders, this.isSystemContext, newWarningHeaderSize);
        }

        private ThreadContextStruct putTransient(Map<String, Object> values) {
            HashMap<String, Object> newTransient = new HashMap<String, Object>(this.transientHeaders);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                ThreadContextStruct.putSingleHeader(entry.getKey(), entry.getValue(), newTransient);
            }
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, newTransient, this.persistentHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putTransient(String key, Object value) {
            HashMap<String, Object> newTransient = new HashMap<String, Object>(this.transientHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newTransient);
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, newTransient, this.persistentHeaders, this.isSystemContext);
        }

        private ThreadContextStruct copyHeaders(Iterable<Map.Entry<String, String>> headers) {
            HashMap<String, String> newHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> header : headers) {
                newHeaders.put(header.getKey(), header.getValue());
            }
            return this.putHeaders(newHeaders);
        }

        private void writeTo(StreamOutput out, Map<String, String> defaultHeaders, Map<String, String> propagatedHeaders) throws IOException {
            Map<String, String> requestHeaders;
            if (defaultHeaders.isEmpty() && propagatedHeaders.isEmpty()) {
                requestHeaders = this.requestHeaders;
            } else {
                requestHeaders = new HashMap<String, String>(defaultHeaders);
                requestHeaders.putAll(this.requestHeaders);
                requestHeaders.putAll(propagatedHeaders);
            }
            out.writeVInt(requestHeaders.size());
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
            out.writeMap(this.responseHeaders, StreamOutput::writeString, StreamOutput::writeStringCollection);
        }
    }

    @FunctionalInterface
    @PublicApi(since="1.0.0")
    public static interface StoredContext
    extends AutoCloseable {
        @Override
        public void close();

        default public void restore() {
            this.close();
        }
    }

    private class ContextPreservingAbstractRunnable
    extends AbstractRunnable
    implements WrappedRunnable {
        private final AbstractRunnable in;
        private final StoredContext creatorsContext;
        private StoredContext threadsOriginalContext = null;

        private ContextPreservingAbstractRunnable(AbstractRunnable in) {
            this.creatorsContext = ThreadContext.this.newStoredContext(false);
            this.in = in;
        }

        @Override
        public boolean isForceExecution() {
            return this.in.isForceExecution();
        }

        @Override
        public void onAfter() {
            try {
                this.in.onAfter();
            }
            finally {
                if (this.threadsOriginalContext != null) {
                    this.threadsOriginalContext.restore();
                }
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.in.onFailure(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.in.onRejection(e);
        }

        @Override
        protected void doRun() throws Exception {
            this.threadsOriginalContext = ThreadContext.this.stashContext();
            this.creatorsContext.restore();
            this.in.doRun();
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public AbstractRunnable unwrap() {
            return this.in;
        }
    }

    private class ContextPreservingRunnable
    implements WrappedRunnable {
        private final Runnable in;
        private final StoredContext ctx;

        private ContextPreservingRunnable(Runnable in) {
            this.ctx = ThreadContext.this.newStoredContext(false);
            this.in = in;
        }

        @Override
        public void run() {
            try (StoredContext ignore = ThreadContext.this.stashContext();){
                this.ctx.restore();
                this.in.run();
            }
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public Runnable unwrap() {
            return this.in;
        }
    }

    private static class LinkedHashSetCollector<T>
    implements Collector<T, Set<T>, Set<T>> {
        private static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

        private LinkedHashSetCollector() {
        }

        @Override
        public Supplier<Set<T>> supplier() {
            return LinkedHashSet::new;
        }

        @Override
        public BiConsumer<Set<T>, T> accumulator() {
            return Set::add;
        }

        @Override
        public BinaryOperator<Set<T>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<Set<T>, Set<T>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }
}

