/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ExtensionDependency
implements Writeable {
    private String uniqueId;
    private Version version;
    private static final String UNIQUE_ID = "uniqueId";
    private static final String VERSION = "version";

    public ExtensionDependency(String uniqueId, Version version) {
        this.uniqueId = uniqueId;
        this.version = version;
    }

    private ExtensionDependency() {
    }

    public ExtensionDependency(StreamInput in) throws IOException {
        this.uniqueId = in.readString();
        this.version = in.readVersion();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uniqueId);
        out.writeVersion(this.version);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return "ExtensionDependency:{uniqueId=" + this.uniqueId + ", version=" + String.valueOf(this.version) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionDependency that = (ExtensionDependency)obj;
        return Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.version);
    }
}

