/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.routingtable;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.index.Index;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteIndexRoutingTable
extends AbstractClusterMetadataWriteableBlobEntity<IndexRoutingTable> {
    public static final String INDEX_ROUTING_TABLE = "index-routing";
    public static final String INDEX_ROUTING_METADATA_PREFIX = "indexRouting--";
    public static final String INDEX_ROUTING_FILE = "index_routing";
    private IndexRoutingTable indexRoutingTable;
    private final Index index;
    private long term;
    private long version;
    private BlobPathParameters blobPathParameters;
    public static final ChecksumWritableBlobStoreFormat<IndexRoutingTable> INDEX_ROUTING_TABLE_FORMAT = new ChecksumWritableBlobStoreFormat<IndexRoutingTable>("index-routing-table", IndexRoutingTable::readFrom);

    public RemoteIndexRoutingTable(IndexRoutingTable indexRoutingTable, String clusterUUID, Compressor compressor, long term, long version) {
        super(clusterUUID, compressor);
        this.index = indexRoutingTable.getIndex();
        this.indexRoutingTable = indexRoutingTable;
        this.term = term;
        this.version = version;
    }

    public RemoteIndexRoutingTable(String blobName, String clusterUUID, Compressor compressor) {
        super(clusterUUID, compressor);
        this.index = null;
        this.term = -1L;
        this.version = -1L;
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        if (this.blobPathParameters == null) {
            this.blobPathParameters = new BlobPathParameters(List.of(this.indexRoutingTable.getIndex().getUUID()), INDEX_ROUTING_FILE);
        }
        return this.blobPathParameters;
    }

    @Override
    public String getType() {
        return INDEX_ROUTING_TABLE;
    }

    @Override
    public String generateBlobFileName() {
        if (this.blobFileName == null) {
            this.blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.term), RemoteStoreUtils.invertLong(this.version), RemoteStoreUtils.invertLong(System.currentTimeMillis()));
        }
        return this.blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        assert (this.index != null);
        return new ClusterMetadataManifest.UploadedIndexMetadata(this.index.getName(), this.index.getUUID(), this.blobName, INDEX_ROUTING_METADATA_PREFIX);
    }

    @Override
    public InputStream serialize() throws IOException {
        return INDEX_ROUTING_TABLE_FORMAT.serialize(this.indexRoutingTable, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public IndexRoutingTable deserialize(InputStream in) throws IOException {
        return INDEX_ROUTING_TABLE_FORMAT.deserialize(this.blobName, Streams.readFully(in));
    }
}

