/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.refresh;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class RefreshStats
implements Writeable,
ToXContentFragment {
    private long total;
    private long totalTimeInMillis;
    private long externalTotal;
    private long externalTotalTimeInMillis;
    private int listeners;

    public RefreshStats() {
    }

    public RefreshStats(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_2_0)) {
            this.externalTotal = in.readVLong();
            this.externalTotalTimeInMillis = in.readVLong();
        }
        this.listeners = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_2_0)) {
            out.writeVLong(this.externalTotal);
            out.writeVLong(this.externalTotalTimeInMillis);
        }
        out.writeVInt(this.listeners);
    }

    public RefreshStats(long total, long totalTimeInMillis, long externalTotal, long externalTotalTimeInMillis, int listeners) {
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
        this.externalTotal = externalTotal;
        this.externalTotalTimeInMillis = externalTotalTimeInMillis;
        this.listeners = listeners;
    }

    public void add(RefreshStats refreshStats) {
        this.addTotals(refreshStats);
    }

    public void addTotals(RefreshStats refreshStats) {
        if (refreshStats == null) {
            return;
        }
        this.total += refreshStats.total;
        this.totalTimeInMillis += refreshStats.totalTimeInMillis;
        this.externalTotal += refreshStats.externalTotal;
        this.externalTotalTimeInMillis += refreshStats.externalTotalTimeInMillis;
        this.listeners += refreshStats.listeners;
    }

    public long getTotal() {
        return this.total;
    }

    public long getExternalTotal() {
        return this.externalTotal;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getExternalTotalTimeInMillis() {
        return this.externalTotalTimeInMillis;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public TimeValue getExternalTotalTime() {
        return new TimeValue(this.externalTotalTimeInMillis);
    }

    public int getListeners() {
        return this.listeners;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("refresh");
        builder.field("total", this.total);
        builder.humanReadableField("total_time_in_millis", "total_time", this.getTotalTime());
        builder.field("external_total", this.externalTotal);
        builder.humanReadableField("external_total_time_in_millis", "external_total_time", this.getExternalTotalTime());
        builder.field("listeners", this.listeners);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RefreshStats.class) {
            return false;
        }
        RefreshStats rhs = (RefreshStats)obj;
        return this.total == rhs.total && this.totalTimeInMillis == rhs.totalTimeInMillis && this.externalTotal == rhs.externalTotal && this.externalTotalTimeInMillis == rhs.externalTotalTimeInMillis && this.listeners == rhs.listeners;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.totalTimeInMillis, this.externalTotal, this.externalTotalTimeInMillis, this.listeners);
    }
}

