/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search.comparators;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.BigIntegerPoint;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.NumericComparator;
import org.opensearch.common.Numbers;

public class UnsignedLongComparator
extends NumericComparator<BigInteger> {
    private final BigInteger[] values;
    protected BigInteger topValue;
    protected BigInteger bottom;

    public UnsignedLongComparator(int numHits, String field, BigInteger missingValue, boolean reverse, Pruning pruning) {
        super(field, missingValue != null ? missingValue : Numbers.MIN_UNSIGNED_LONG_VALUE, reverse, pruning, 16);
        this.values = new BigInteger[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.values[slot1].compareTo(this.values[slot2]);
    }

    @Override
    public void setTopValue(BigInteger value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public BigInteger value(int slot) {
        return this.values[slot];
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new UnsignedLongLeafComparator(context);
    }

    public class UnsignedLongLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public UnsignedLongLeafComparator(LeafReaderContext context) throws IOException {
            super(context);
        }

        private BigInteger getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Numbers.toUnsignedBigInteger(this.docValues.longValue());
            }
            return (BigInteger)UnsignedLongComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            UnsignedLongComparator.this.bottom = UnsignedLongComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return UnsignedLongComparator.this.bottom.compareTo(this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return UnsignedLongComparator.this.topValue.compareTo(this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            UnsignedLongComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected void encodeBottom(byte[] packedValue) {
            BigIntegerPoint.encodeDimension(UnsignedLongComparator.this.bottom, packedValue, 0);
        }

        @Override
        protected void encodeTop(byte[] packedValue) {
            BigIntegerPoint.encodeDimension(UnsignedLongComparator.this.topValue, packedValue, 0);
        }

        @Override
        protected int compareMissingValueWithBottomValue() {
            return ((BigInteger)UnsignedLongComparator.this.missingValue).compareTo(UnsignedLongComparator.this.bottom);
        }

        @Override
        protected int compareMissingValueWithTopValue() {
            return ((BigInteger)UnsignedLongComparator.this.missingValue).compareTo(UnsignedLongComparator.this.topValue);
        }
    }
}

