/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.process;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.SingleObjectCache;
import org.opensearch.core.service.ReportingService;
import org.opensearch.monitor.process.ProcessInfo;
import org.opensearch.monitor.process.ProcessProbe;
import org.opensearch.monitor.process.ProcessStats;

public final class ProcessService
implements ReportingService<ProcessInfo> {
    private static final Logger logger = LogManager.getLogger(ProcessService.class);
    private final ProcessProbe probe = ProcessProbe.getInstance();
    private final ProcessInfo info;
    private final SingleObjectCache<ProcessStats> processStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.process.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public ProcessService(Settings settings) {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.processStatsCache = new ProcessStatsCache(refreshInterval, this.probe.processStats());
        this.info = this.probe.processInfo(refreshInterval.millis());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public ProcessInfo info() {
        return this.info;
    }

    public ProcessStats stats() {
        return this.processStatsCache.getOrRefresh();
    }

    private class ProcessStatsCache
    extends SingleObjectCache<ProcessStats> {
        ProcessStatsCache(TimeValue interval, ProcessStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected ProcessStats refresh() {
            return ProcessService.this.probe.processStats();
        }
    }
}

