/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.Numbers;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.joda.Joda;
import org.opensearch.common.joda.JodaDateFormatter;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.common.time.DateUtils;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.geometry.utils.Geohash;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.search.aggregations.bucket.GeoTileUtils;

@PublicApi(since="1.0.0")
public interface DocValueFormat
extends NamedWriteable {
    public static final long MASK_2_63 = Long.MIN_VALUE;
    public static final BigInteger BIGINTEGER_2_64_MINUS_ONE = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public static final DocValueFormat RAW = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "raw";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public Long format(long value) {
            return value;
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public BigInteger format(BigInteger value) {
            return value;
        }

        @Override
        public String format(BytesRef value) {
            return value.utf8ToString();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(value);
                d = roundUp ? Math.ceil(d) : Math.floor(d);
                return Math.round(d);
            }
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(value);
        }

        public String toString() {
            return "raw";
        }
    };
    public static final DocValueFormat BINARY = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "binary";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(BytesRef value) {
            return Base64.getEncoder().withoutPadding().encodeToString(Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length));
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(Base64.getDecoder().decode(value));
        }
    };
    public static final DocValueFormat GEOHASH = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "geo_hash";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(long value) {
            return Geohash.stringEncode(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }
    };
    public static final DocValueFormat GEOTILE = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "geo_tile";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(long value) {
            return GeoTileUtils.stringEncode(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }
    };
    public static final DocValueFormat BOOLEAN = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "bool";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public Boolean format(long value) {
            return value != 0L;
        }

        @Override
        public Boolean format(double value) {
            return value != 0.0;
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            switch (value) {
                case "false": {
                    return 0L;
                }
                case "true": {
                    return 1L;
                }
            }
            throw new IllegalArgumentException("Cannot parse boolean [" + value + "], expected either [true] or [false]");
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }
    };
    public static final DocValueFormat IP = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "ip";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(BytesRef value) {
            byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
            InetAddress inet = InetAddressPoint.decode(bytes);
            return NetworkAddress.format(inet);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(InetAddressPoint.encode(InetAddresses.forString(value)));
        }

        public String toString() {
            return "ip";
        }
    };
    public static final DocValueFormat UNSIGNED_LONG_SHIFTED = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "unsigned_long_shifted";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        public String toString() {
            return "unsigned_long_shifted";
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            long parsedValue = Long.parseUnsignedLong(value);
            return parsedValue ^ Long.MIN_VALUE;
        }

        @Override
        public BigInteger parseUnsignedLong(String value, boolean roundUp, LongSupplier now) {
            return Numbers.toUnsignedLong(value, roundUp);
        }

        @Override
        public Object format(long value) {
            long formattedValue = value ^ Long.MIN_VALUE;
            if (formattedValue >= 0L) {
                return formattedValue;
            }
            return BigInteger.valueOf(formattedValue).and(BIGINTEGER_2_64_MINUS_ONE);
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }
    };
    public static final DocValueFormat UNSIGNED_LONG = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "unsigned_long";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        public String toString() {
            return "unsigned_long";
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            return Long.parseUnsignedLong(value);
        }

        @Override
        public BigInteger parseUnsignedLong(String value, boolean roundUp, LongSupplier now) {
            return Numbers.toUnsignedLong(value, roundUp);
        }

        @Override
        public Object format(long value) {
            return Numbers.toUnsignedBigInteger(value);
        }

        @Override
        public BigInteger format(BigInteger value) {
            return value;
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }
    };

    default public Object format(long value) {
        throw new UnsupportedOperationException();
    }

    default public Object format(double value) {
        throw new UnsupportedOperationException();
    }

    default public BigInteger format(BigInteger value) {
        throw new UnsupportedOperationException();
    }

    default public Object format(BytesRef value) {
        throw new UnsupportedOperationException();
    }

    default public long parseLong(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public BigInteger parseUnsignedLong(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public double parseDouble(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public BytesRef parseBytesRef(String value) {
        throw new UnsupportedOperationException();
    }

    public static DocValueFormat withNanosecondResolution(DocValueFormat format) {
        if (format instanceof DateTime) {
            DateTime dateTime = (DateTime)format;
            return new DateTime(dateTime.formatter, dateTime.timeZone, DateFieldMapper.Resolution.NANOSECONDS);
        }
        throw new IllegalArgumentException("trying to convert a known date time formatter to a nanosecond one, wrong field used?");
    }

    public static final class DateTime
    implements DocValueFormat {
        public static final String NAME = "date_time";
        final DateFormatter formatter;
        final ZoneId timeZone;
        private final DateMathParser parser;
        final DateFieldMapper.Resolution resolution;

        public DateTime(DateFormatter formatter, ZoneId timeZone, DateFieldMapper.Resolution resolution) {
            this.formatter = formatter;
            this.timeZone = Objects.requireNonNull(timeZone);
            this.parser = formatter.toDateMathParser();
            this.resolution = resolution;
        }

        public DateTime(StreamInput in) throws IOException {
            String datePattern = in.readString();
            String printPattern = null;
            if (in.getVersion().onOrAfter(Version.V_2_12_0)) {
                printPattern = in.readOptionalString();
            }
            String zoneId = in.readString();
            if (in.getVersion().before(LegacyESVersion.V_7_0_0)) {
                this.timeZone = DateUtils.of(zoneId);
                this.resolution = DateFieldMapper.Resolution.MILLISECONDS;
            } else {
                this.timeZone = ZoneId.of(zoneId);
                this.resolution = DateFieldMapper.Resolution.ofOrdinal(in.readVInt());
            }
            boolean isJoda = in.getVersion().onOrAfter(LegacyESVersion.V_7_7_0) ? in.readBoolean() : Joda.isJodaPattern(in.getVersion(), datePattern);
            this.formatter = isJoda ? Joda.forPattern(datePattern) : DateFormatter.forPattern(datePattern, printPattern);
            this.parser = this.formatter.toDateMathParser();
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().before(Version.V_2_12_0) && this.formatter.equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER)) {
                out.writeString(DateFieldMapper.LEGACY_DEFAULT_DATE_TIME_FORMATTER.pattern());
            } else {
                out.writeString(this.formatter.pattern());
            }
            if (out.getVersion().onOrAfter(Version.V_2_12_0)) {
                out.writeOptionalString(this.formatter.printPattern());
            }
            if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
                out.writeString(DateUtils.zoneIdToDateTimeZone(this.timeZone).getID());
            } else {
                out.writeString(this.timeZone.getId());
                out.writeVInt(this.resolution.ordinal());
            }
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_7_0)) {
                out.writeBoolean(this.formatter instanceof JodaDateFormatter);
            }
        }

        public DateMathParser getDateMathParser() {
            return this.parser;
        }

        @Override
        public String format(long value) {
            return this.formatter.format(this.resolution.toInstant(value).atZone(this.timeZone));
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            return this.resolution.convert(this.parser.parse(value, now, roundUp, this.timeZone));
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }

        public String toString() {
            return "DocValueFormat.DateTime(" + String.valueOf(this.formatter) + ", " + String.valueOf(this.timeZone) + ", " + String.valueOf((Object)this.resolution) + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateTime that = (DateTime)o;
            return Objects.equals(this.formatter, that.formatter) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals((Object)this.resolution, (Object)that.resolution);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.formatter, this.timeZone, this.resolution});
        }
    }

    public static final class Decimal
    implements DocValueFormat {
        public static final String NAME = "decimal";
        private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
        final String pattern;
        private final NumberFormat format;

        public Decimal(String pattern) {
            this.pattern = pattern;
            this.format = new DecimalFormat(pattern, SYMBOLS);
        }

        public Decimal(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
        }

        @Override
        public String format(long value) {
            return this.format.format(value);
        }

        @Override
        public BigInteger format(BigInteger value) {
            return value;
        }

        @Override
        public String format(double value) {
            if (Double.isNaN(value)) {
                return String.valueOf(Double.NaN);
            }
            return this.format.format(value);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (this.format.isParseIntegerOnly()) {
                return n.longValue();
            }
            double d = n.doubleValue();
            d = roundUp ? Math.ceil(d) : Math.floor(d);
            return Math.round(d);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return n.doubleValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Decimal that = (Decimal)o;
            return Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern);
        }
    }
}

