/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.common.Nullable;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitAdapter;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.filterrewrite.DateHistogramAggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.StarTreeTraversalUtil;
import org.opensearch.search.startree.filter.DimensionFilter;

class DateHistogramAggregator
extends BucketsAggregator
implements SizedBucketAggregator,
StarTreePreComputeCollector {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;
    private final String starTreeDateDimension;
    private boolean starTreeDateRoundingRequired = true;
    private final FilterRewriteOptimizationContext filterRewriteOptimizationContext;
    public final String fieldName;

    DateHistogramAggregator(String name, AggregatorFactories factories, final Rounding rounding, final Rounding.Prepared preparedRounding, BucketOrder order, boolean keyed, long minDocCount, @Nullable LongBounds extendedBounds, final @Nullable LongBounds hardBounds, final ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = preparedRounding;
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), cardinality);
        DateHistogramAggregatorBridge bridge = new DateHistogramAggregatorBridge(){

            @Override
            protected boolean canOptimize() {
                return this.canOptimize(valuesSourceConfig, rounding);
            }

            @Override
            protected void prepare() throws IOException {
                this.buildRanges(DateHistogramAggregator.this.context);
            }

            @Override
            protected Rounding getRounding(long low, long high) {
                return rounding;
            }

            @Override
            protected Rounding.Prepared getRoundingPrepared() {
                return preparedRounding;
            }

            @Override
            protected long[] processHardBounds(long[] bounds) {
                return super.processHardBounds(bounds, hardBounds);
            }

            @Override
            protected Function<Long, Long> bucketOrdProducer() {
                return key -> DateHistogramAggregator.this.bucketOrds.add(0L, preparedRounding.round((long)key));
            }
        };
        this.filterRewriteOptimizationContext = new FilterRewriteOptimizationContext(bridge, parent, this.subAggregators.length, this.context);
        this.fieldName = this.valuesSource instanceof ValuesSource.Numeric.FieldData ? ((ValuesSource.Numeric.FieldData)this.valuesSource).getIndexFieldName() : null;
        this.starTreeDateDimension = this.context.getQueryShardContext().getStarTreeQueryContext() != null ? this.fetchStarTreeCalendarUnit() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null && this.preComputeWithStarTree(ctx, supportedStarTree)) {
            return true;
        }
        return this.filterRewriteOptimizationContext.tryOptimize(ctx, this::incrementBucketDocCount, DateHistogramAggregatorBridge.segmentMatchAll(this.context, ctx));
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = DateHistogramAggregator.this.preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        if (DateHistogramAggregator.this.hardBounds == null || DateHistogramAggregator.this.hardBounds.contain(rounded)) {
                            long bucketOrd = DateHistogramAggregator.this.bucketOrds.add(owningBucketOrd, rounded);
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                DateHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                DateHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                        previousRounded = rounded;
                    }
                }
            }
        };
    }

    private String fetchStarTreeCalendarUnit() {
        if (this.rounding.unit() == null) {
            return null;
        }
        CompositeDataCubeFieldType compositeMappedFieldType = (CompositeDataCubeFieldType)this.context.mapperService().getCompositeFieldTypes().iterator().next();
        DateDimension starTreeDateDimension = (DateDimension)compositeMappedFieldType.getDimensions().stream().filter(dim -> dim.getField().equals(this.fieldName)).findFirst().orElseThrow(() -> new AssertionError((Object)String.format(Locale.ROOT, "Date dimension '%s' not found", this.fieldName)));
        DateTimeUnitAdapter dateTimeUnitRounding = new DateTimeUnitAdapter(this.rounding.unit());
        DateTimeUnitRounding rounding = starTreeDateDimension.findClosestValidInterval(dateTimeUnitRounding);
        String dimensionName = this.fieldName + "_" + rounding.shortName();
        if (rounding.shortName().equals(this.rounding.unit().shortName())) {
            this.starTreeDateRoundingRequired = false;
        }
        return dimensionName;
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(final LeafReaderContext ctx, final CompositeIndexFieldInfo starTree, StarTreeBucketCollector parentCollector) throws IOException {
        assert (parentCollector == null);
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        return new StarTreeBucketCollector(starTreeValues, StarTreeTraversalUtil.getStarTreeResult(starTreeValues, StarTreeQueryHelper.mergeDimensionFilterIfNotExists(this.context.getQueryShardContext().getStarTreeQueryContext().getBaseQueryStarTreeFilter(), this.starTreeDateDimension, List.of(DimensionFilter.MATCH_ALL_DEFAULT)), this.context)){
            SortedNumericStarTreeValuesIterator valuesIterator;
            String metricName;
            SortedNumericStarTreeValuesIterator docCountsIterator;
            {
                super(starTreeValues, matchingDocsBitSet);
                this.valuesIterator = (SortedNumericStarTreeValuesIterator)this.starTreeValues.getDimensionValuesIterator(DateHistogramAggregator.this.starTreeDateDimension);
                this.metricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), "_doc_count", MetricStat.DOC_COUNT.getTypeName());
                this.docCountsIterator = (SortedNumericStarTreeValuesIterator)this.starTreeValues.getMetricValuesIterator(this.metricName);
            }

            @Override
            public void setSubCollectors() throws IOException {
                for (Aggregator aggregator : DateHistogramAggregator.this.subAggregators) {
                    this.subCollectors.add(((StarTreePreComputeCollector)((Object)aggregator)).getStarTreeBucketCollector(ctx, starTree, this));
                }
            }

            @Override
            public void collectStarTreeEntry(int starTreeEntry, long owningBucketOrd) throws IOException {
                if (!this.valuesIterator.advanceExact(starTreeEntry)) {
                    return;
                }
                int count = this.valuesIterator.entryValueCount();
                for (int i = 0; i < count; ++i) {
                    long dimensionValue;
                    long l = dimensionValue = DateHistogramAggregator.this.starTreeDateRoundingRequired ? DateHistogramAggregator.this.preparedRounding.round(this.valuesIterator.nextValue()) : this.valuesIterator.nextValue();
                    if (!this.docCountsIterator.advanceExact(starTreeEntry)) continue;
                    long metricValue = this.docCountsIterator.nextValue();
                    long bucketOrd = DateHistogramAggregator.this.bucketOrds.add(owningBucketOrd, dimensionValue);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        DateHistogramAggregator.this.collectStarTreeBucket(this, metricValue, bucketOrd, starTreeEntry);
                        continue;
                    }
                    DateHistogramAggregator.this.grow(bucketOrd + 1L);
                    DateHistogramAggregator.this.collectStarTreeBucket(this, metricValue, bucketOrd, starTreeEntry);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.keyed, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
        this.filterRewriteOptimizationContext.populateDebugInfo(add);
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(this.bucketOrds.get(bucket), unitSize);
        }
        return 1.0;
    }

    private boolean preComputeWithStarTree(LeafReaderContext ctx, CompositeIndexFieldInfo starTree) throws IOException {
        StarTreeBucketCollector starTreeBucketCollector = this.getStarTreeBucketCollector(ctx, starTree, null);
        FixedBitSet matchingDocsBitSet = starTreeBucketCollector.getMatchingDocsBitSet();
        int numBits = matchingDocsBitSet.length();
        if (numBits > 0) {
            int bit = matchingDocsBitSet.nextSetBit(0);
            while (bit != Integer.MAX_VALUE) {
                starTreeBucketCollector.collectStarTreeEntry(bit, 0L);
                bit = bit + 1 < numBits ? matchingDocsBitSet.nextSetBit(bit + 1) : Integer.MAX_VALUE;
            }
        }
        return true;
    }
}

