/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.pipeline.PipelineConfiguration;

public class SearchPipelineMetadata
implements Metadata.Custom {
    public static final String TYPE = "search_pipeline";
    private static final ParseField PIPELINES_FIELD = new ParseField("pipeline", new String[0]);
    private static final ObjectParser<List<PipelineConfiguration>, Void> SEARCH_PIPELINE_METADATA_PARSER = new ObjectParser("search_pipeline_metadata", ArrayList::new);
    private final Map<String, PipelineConfiguration> pipelines;

    public SearchPipelineMetadata(Map<String, PipelineConfiguration> pipelines) {
        this.pipelines = Collections.unmodifiableMap(pipelines);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public Map<String, PipelineConfiguration> getPipelines() {
        return this.pipelines;
    }

    public SearchPipelineMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<String, PipelineConfiguration> pipelines = new HashMap<String, PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            PipelineConfiguration pipeline = PipelineConfiguration.readFrom(in);
            pipelines.put(pipeline.getId(), pipeline);
        }
        this.pipelines = Collections.unmodifiableMap(pipelines);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.pipelines.size());
        for (PipelineConfiguration pipeline : this.pipelines.values()) {
            pipeline.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(PIPELINES_FIELD.getPreferredName());
        for (PipelineConfiguration pipeline : this.pipelines.values()) {
            pipeline.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static SearchPipelineMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, PipelineConfiguration> pipelines = new HashMap<String, PipelineConfiguration>();
        List<PipelineConfiguration> configs = SEARCH_PIPELINE_METADATA_PARSER.parse(parser, null);
        for (PipelineConfiguration pipeline : configs) {
            pipelines.put(pipeline.getId(), pipeline);
        }
        return new SearchPipelineMetadata(pipelines);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new SearchPipelineMetadataDiff((SearchPipelineMetadata)previousState, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new SearchPipelineMetadataDiff(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPipelineMetadata that = (SearchPipelineMetadata)o;
        return this.pipelines.equals(that.pipelines);
    }

    public int hashCode() {
        return this.pipelines.hashCode();
    }

    static {
        SEARCH_PIPELINE_METADATA_PARSER.declareObjectArray(List::addAll, PipelineConfiguration.getParser(), PIPELINES_FIELD);
    }

    static class SearchPipelineMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, PipelineConfiguration>> pipelines;

        public SearchPipelineMetadataDiff(SearchPipelineMetadata before, SearchPipelineMetadata after) {
            this.pipelines = DiffableUtils.diff(before.pipelines, after.pipelines, DiffableUtils.getStringKeySerializer());
        }

        public SearchPipelineMetadataDiff(StreamInput in) throws IOException {
            this.pipelines = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), PipelineConfiguration::readFrom, PipelineConfiguration::readDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new SearchPipelineMetadata(this.pipelines.apply(((SearchPipelineMetadata)part).pipelines));
        }

        @Override
        public String getWriteableName() {
            return SearchPipelineMetadata.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.pipelines.writeTo(out);
        }
    }
}

