/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.stats.QueryGroupState;

public class QueryGroupStats
implements ToXContentObject,
Writeable {
    private final Map<String, QueryGroupStatsHolder> stats;

    public QueryGroupStats(Map<String, QueryGroupStatsHolder> stats) {
        this.stats = stats;
    }

    public QueryGroupStats(StreamInput in) throws IOException {
        this.stats = in.readMap(StreamInput::readString, QueryGroupStatsHolder::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.stats, StreamOutput::writeString, QueryGroupStatsHolder::writeTo);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("query_groups");
        ArrayList<Map.Entry<String, QueryGroupStatsHolder>> entryList = new ArrayList<Map.Entry<String, QueryGroupStatsHolder>>(this.stats.entrySet());
        entryList.sort((k1, k2) -> ((String)k1.getKey()).compareTo((String)k2.getKey()));
        for (Map.Entry entry : entryList) {
            builder.startObject((String)entry.getKey());
            ((QueryGroupStatsHolder)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryGroupStats that = (QueryGroupStats)o;
        return Objects.equals(this.stats, that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats);
    }

    public Map<String, QueryGroupStatsHolder> getStats() {
        return this.stats;
    }

    public static class QueryGroupStatsHolder
    implements ToXContentObject,
    Writeable {
        public static final String COMPLETIONS = "total_completions";
        public static final String REJECTIONS = "total_rejections";
        public static final String TOTAL_CANCELLATIONS = "total_cancellations";
        public static final String FAILURES = "failures";
        private long completions;
        private long rejections;
        private long failures;
        private long cancellations;
        private Map<ResourceType, ResourceStats> resourceStats;

        public QueryGroupStatsHolder() {
        }

        public QueryGroupStatsHolder(long completions, long rejections, long failures, long cancellations, Map<ResourceType, ResourceStats> resourceStats) {
            this.completions = completions;
            this.rejections = rejections;
            this.failures = failures;
            this.cancellations = cancellations;
            this.resourceStats = resourceStats;
        }

        public QueryGroupStatsHolder(StreamInput in) throws IOException {
            this.completions = in.readVLong();
            this.rejections = in.readVLong();
            this.failures = in.readVLong();
            this.cancellations = in.readVLong();
            this.resourceStats = in.readMap(i -> ResourceType.fromName(i.readString()), ResourceStats::new);
        }

        public static QueryGroupStatsHolder from(QueryGroupState queryGroupState) {
            QueryGroupStatsHolder statsHolder = new QueryGroupStatsHolder();
            HashMap<ResourceType, ResourceStats> resourceStatsMap = new HashMap<ResourceType, ResourceStats>();
            for (Map.Entry<ResourceType, QueryGroupState.ResourceTypeState> resourceTypeStateEntry : queryGroupState.getResourceState().entrySet()) {
                resourceStatsMap.put(resourceTypeStateEntry.getKey(), ResourceStats.from(resourceTypeStateEntry.getValue()));
            }
            statsHolder.completions = queryGroupState.getTotalCompletions();
            statsHolder.rejections = queryGroupState.getTotalRejections();
            statsHolder.failures = queryGroupState.getFailures();
            statsHolder.cancellations = queryGroupState.getTotalCancellations();
            statsHolder.resourceStats = resourceStatsMap;
            return statsHolder;
        }

        public static void writeTo(StreamOutput out, QueryGroupStatsHolder statsHolder) throws IOException {
            out.writeVLong(statsHolder.completions);
            out.writeVLong(statsHolder.rejections);
            out.writeVLong(statsHolder.failures);
            out.writeVLong(statsHolder.cancellations);
            out.writeMap(statsHolder.resourceStats, (o, val) -> o.writeString(val.getName()), ResourceStats::writeTo);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            QueryGroupStatsHolder.writeTo(out, this);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(COMPLETIONS, this.completions);
            builder.field(REJECTIONS, this.rejections);
            builder.field(TOTAL_CANCELLATIONS, this.cancellations);
            for (ResourceType resourceType : ResourceType.getSortedValues()) {
                ResourceStats resourceStats1 = this.resourceStats.get((Object)resourceType);
                if (resourceStats1 == null) continue;
                builder.startObject(resourceType.getName());
                resourceStats1.toXContent(builder, params);
                builder.endObject();
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryGroupStatsHolder that = (QueryGroupStatsHolder)o;
            return this.completions == that.completions && this.rejections == that.rejections && Objects.equals(this.resourceStats, that.resourceStats) && this.failures == that.failures && this.cancellations == that.cancellations;
        }

        public int hashCode() {
            return Objects.hash(this.completions, this.rejections, this.cancellations, this.failures, this.resourceStats);
        }
    }

    public static class ResourceStats
    implements ToXContentObject,
    Writeable {
        public static final String CURRENT_USAGE = "current_usage";
        public static final String CANCELLATIONS = "cancellations";
        public static final String REJECTIONS = "rejections";
        public static final double PRECISION = 1.0E-9;
        private final double currentUsage;
        private final long cancellations;
        private final long rejections;

        public ResourceStats(double currentUsage, long cancellations, long rejections) {
            this.currentUsage = currentUsage;
            this.cancellations = cancellations;
            this.rejections = rejections;
        }

        public ResourceStats(StreamInput in) throws IOException {
            this.currentUsage = in.readDouble();
            this.cancellations = in.readVLong();
            this.rejections = in.readVLong();
        }

        public static ResourceStats from(QueryGroupState.ResourceTypeState resourceTypeState) {
            return new ResourceStats(resourceTypeState.getLastRecordedUsage(), resourceTypeState.cancellations.count(), resourceTypeState.rejections.count());
        }

        public static void writeTo(StreamOutput out, ResourceStats stats) throws IOException {
            out.writeDouble(stats.currentUsage);
            out.writeVLong(stats.cancellations);
            out.writeVLong(stats.rejections);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            ResourceStats.writeTo(out, this);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(CURRENT_USAGE, this.currentUsage);
            builder.field(CANCELLATIONS, this.cancellations);
            builder.field(REJECTIONS, this.rejections);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceStats that = (ResourceStats)o;
            return this.currentUsage - that.currentUsage < 1.0E-9 && this.cancellations == that.cancellations && this.rejections == that.rejections;
        }

        public int hashCode() {
            return Objects.hash(this.currentUsage, this.cancellations, this.rejections);
        }
    }
}

