/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class SessionBasedQuery {
    private static final Logger LOGGER = LogManager.getLogger(SessionBasedQuery.class);
    public static final String DATA_FILTER_BASEFILTER_KEY = "baseFilter";
    public static final String DATA_FILTER_ORGANISATIONS_KEY = "organisations";
    public static final String DATA_FILTER_ROLES_KEY = "roles";
    public static final String DATA_FILTER_RIGHTS_KEY = "rights";
    public static final String DATA_FILTER_USERS_KEY = "users";

    public static QueryBuilder getQueryBuilder(UserSession session, Map<String, Object> dataFilterConfig, String dataFilterOperator) throws IOException {
        LOGGER.info("getQueryBuilder session=..., dataFilterConfig=...");
        BoolQueryBuilder sessionQuery = null;
        if (dataFilterConfig == null) {
            LOGGER.warn("No filter config found");
            return QueryBuilders.matchAllQuery();
        }
        BoolQueryBuilder baseQuery = QueryBuilders.boolQuery();
        if (dataFilterConfig.containsKey(DATA_FILTER_BASEFILTER_KEY)) {
            baseQuery = SessionBasedQuery.getQueryForList((List)dataFilterConfig.get(DATA_FILTER_BASEFILTER_KEY), session);
        }
        if (baseQuery.hasClauses()) {
            LOGGER.info("add baseQuery");
            sessionQuery = QueryBuilders.boolQuery();
            if ("and".equalsIgnoreCase(dataFilterOperator)) {
                sessionQuery.mustNot((QueryBuilder)baseQuery);
            } else {
                sessionQuery.should((QueryBuilder)baseQuery);
            }
        } else {
            sessionQuery = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_ROLES_KEY)) {
            BoolQueryBuilder roleQuery = QueryBuilders.boolQuery();
            Map roles = (Map)dataFilterConfig.get(DATA_FILTER_ROLES_KEY);
            List sessionRoles = session.getRoles();
            for (Role role : sessionRoles) {
                if (!roles.containsKey(role.getName())) continue;
                roleQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)roles.get(role.getName()), session));
            }
            if (roles.containsKey("#")) {
                for (Role role : sessionRoles) {
                    roleQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)roles.get("#"), "#this.name#", role.getName(), session));
                }
            }
            if (roleQuery.hasClauses()) {
                LOGGER.info("add roleQuery");
                SessionBasedQuery.applyQueryOperator(sessionQuery, (QueryBuilder)roleQuery, dataFilterOperator);
            }
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_RIGHTS_KEY)) {
            BoolQueryBuilder rightQuery = QueryBuilders.boolQuery();
            Map rights = (Map)dataFilterConfig.get(DATA_FILTER_RIGHTS_KEY);
            List sessionRights = session.getRights();
            for (Right right : sessionRights) {
                if (!rights.containsKey(right.getName())) continue;
                rightQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)rights.get(right.getName()), session));
            }
            if (rights.containsKey("#")) {
                for (Right right : sessionRights) {
                    rightQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)rights.get("#"), "#this.name#", right.getName(), session));
                }
            }
            if (rightQuery.hasClauses()) {
                LOGGER.info("add rightQuery");
                SessionBasedQuery.applyQueryOperator(sessionQuery, (QueryBuilder)rightQuery, dataFilterOperator);
            }
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_ORGANISATIONS_KEY)) {
            BoolQueryBuilder organisationQuery = QueryBuilders.boolQuery();
            Map organisations = (Map)dataFilterConfig.get(DATA_FILTER_ORGANISATIONS_KEY);
            List sessionOrganisations = session.getOrganisations();
            for (Organisation org : sessionOrganisations) {
                if (!organisations.containsKey(org.getName())) continue;
                organisationQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)organisations.get(org.getName()), session));
            }
            if (organisations.containsKey("#")) {
                for (Organisation org : sessionOrganisations) {
                    organisationQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)organisations.get("#"), "#this.name#", org.getName(), session));
                }
            }
            if (organisationQuery.hasClauses()) {
                LOGGER.info("add organisationQuery");
                SessionBasedQuery.applyQueryOperator(sessionQuery, (QueryBuilder)organisationQuery, dataFilterOperator);
            }
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_USERS_KEY)) {
            String userName;
            BoolQueryBuilder usersQuery = QueryBuilders.boolQuery();
            Map users = (Map)dataFilterConfig.get(DATA_FILTER_USERS_KEY);
            if (users.containsKey(userName = session.getLoginName())) {
                usersQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)users.get(userName), session));
            }
            if (users.containsKey("#")) {
                usersQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)users.get("#"), "#this.name#", userName, session));
            }
            if (usersQuery.hasClauses()) {
                LOGGER.info("add usersQuery");
                SessionBasedQuery.applyQueryOperator(sessionQuery, (QueryBuilder)usersQuery, dataFilterOperator);
            }
        }
        return sessionQuery;
    }

    public static QueryBuilder getQueryForMap(Map<String, Object> filterMap, UserSession session) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return QueryBuilders.wrapperQuery((String)SessionBasedQuery.prepareFilterString(session, om.writeValueAsString(filterMap)));
    }

    private static BoolQueryBuilder getQueryForList(List<Map<String, Object>> filterList, UserSession session) throws IOException {
        LOGGER.info("getQueryForList");
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (Map<String, Object> filterMap : filterList) {
            LOGGER.info("add wrapperQuery");
            query.must(SessionBasedQuery.getQueryForMap(filterMap, session));
        }
        return query;
    }

    private static BoolQueryBuilder getReplacedQueryForList(List<Map<String, Object>> filterList, String pattern, String replaceString, UserSession session) throws IOException {
        LOGGER.debug("getReplacedQueryForList filterList={}, pattern={}, replaceString={}", filterList, (Object)pattern, (Object)replaceString);
        if (!StringUtil.isNullOrEmpty((String)replaceString)) {
            replaceString = JsonUtil.crunchifyJSONEscapeUtil((String)replaceString);
        }
        ObjectMapper om = new ObjectMapper();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (Map<String, Object> filterMap : filterList) {
            LOGGER.info("add wrapperQuery");
            String filterAsString = om.writeValueAsString(filterMap);
            String filterAsStringWithPatternReplaced = filterAsString.replaceAll(pattern, Matcher.quoteReplacement(replaceString));
            query.must((QueryBuilder)QueryBuilders.wrapperQuery((String)SessionBasedQuery.prepareFilterString(session, filterAsStringWithPatternReplaced)));
        }
        return query;
    }

    public static String prepareFilterString(UserSession userSession, String filterString) {
        LOGGER.debug("prepareFilterString userSession={}, filterString={}", (Object)userSession, (Object)filterString);
        if (userSession == null || filterString == null) {
            return filterString;
        }
        return filterString.replaceAll("#user.loginName#", userSession.getLoginName());
    }

    private static void applyQueryOperator(BoolQueryBuilder sessionQuery, QueryBuilder query, String dataFilterOperator) {
        if ("and".equalsIgnoreCase(dataFilterOperator)) {
            sessionQuery.must(query);
        } else if ("or".equalsIgnoreCase(dataFilterOperator)) {
            sessionQuery.should(query);
        } else {
            throw new IllegalArgumentException("Invalid dataFilterOperator: " + dataFilterOperator);
        }
    }
}

