/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.module.monitor.resource.MonitorDataExporter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.SearchHit;

public class MonitorDataJsonExporter
extends MonitorDataExporter {
    private static final Logger LOGGER = LogManager.getLogger(MonitorDataJsonExporter.class);
    public static final String MONITOR_COLUMN_CONFIG_IDENTIFIER_JSON_EXPORT_FORMAT = "formatJsonExport";
    private boolean useCustomColumnHeaders = true;
    private boolean useUtcDateFormat;
    private final TimeZone timeZone;
    private final SimpleDateFormat defaultDateFormat;
    private final HashMap<String, SimpleDateFormat> dateFormatsCache;

    public MonitorDataJsonExporter(ModuleInstance mi, MappingMetadata mappingMetaData, List<String> inclOnlyThisColumns, boolean inclHidden, String timeZoneId, Map<String, Object> translationsForBpcLanguage) throws IOException {
        super(mi, mappingMetaData, inclOnlyThisColumns, inclHidden, translationsForBpcLanguage);
        this.timeZone = timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null;
        LOGGER.info("Using the time zone: {} (null = using the server time zone). Given timeZoneId: {}", (Object)this.timeZone, (Object)timeZoneId);
        this.defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.timeZone != null) {
            this.defaultDateFormat.setTimeZone(this.timeZone);
        }
        LOGGER.info("Using the time zone: {} (null = using the server time zone). Given timeZoneId: {}", (Object)this.timeZone, (Object)timeZoneId);
        this.dateFormatsCache = new HashMap();
    }

    public boolean isUseCustomColumnHeaders() {
        return this.useCustomColumnHeaders;
    }

    public void setUseCustomColumnHeaders(boolean useCustomColumnHeaders) {
        this.useCustomColumnHeaders = useCustomColumnHeaders;
    }

    public boolean isUseUtcDateFormat() {
        return this.useUtcDateFormat;
    }

    public void setUseUtcDateFormat(boolean useUtcDateFormat) {
        this.useUtcDateFormat = useUtcDateFormat;
    }

    private SimpleDateFormat getDateFormat(String columnName) {
        String customDateFormat = this.getMonitorColumnConfigStringSetting(columnName, MONITOR_COLUMN_CONFIG_IDENTIFIER_JSON_EXPORT_FORMAT);
        if (customDateFormat != null) {
            try {
                SimpleDateFormat dateFormat = this.dateFormatsCache.get(customDateFormat);
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(customDateFormat);
                    if (this.timeZone != null) {
                        dateFormat.setTimeZone(this.timeZone);
                    }
                    this.dateFormatsCache.put(customDateFormat, dateFormat);
                }
                return dateFormat;
            }
            catch (Exception ex) {
                LOGGER.error("The JSON export date pattern '{}' for the the column '{}' is invalid (must be a Java SimpleDateFormat pattern).", (Object)customDateFormat, (Object)columnName, (Object)ex);
            }
        }
        return null;
    }

    public void writeSearchResponseToOutputStream(RestHighLevelClient osClient, SearchResponse scrollResp, Integer limit, OutputStream outputStream) throws IOException {
        LOGGER.info("writeSearchResponseToOutputStream");
        ArrayList<MonitorDataExporter.MonitorDataExportColumn> monitorDataExportColumns = this.getMonitorDataExportColumns(this.useCustomColumnHeaders);
        ObjectMapper mapper = new ObjectMapper();
        long totalCount = scrollResp.getHits().getTotalHits().value;
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));){
            bw.write("{");
            bw.newLine();
            bw.write("\"totalCount\":");
            bw.write("" + totalCount);
            bw.write(",");
            bw.newLine();
            bw.write("\"data\":");
            bw.write("[");
            bw.newLine();
            int rowIdx = 0;
            boolean done = false;
            while (!done) {
                for (SearchHit hit : scrollResp.getHits().getHits()) {
                    Map sourceValues = hit.getSourceAsMap();
                    HashMap<String, String> jsonValues = new HashMap<String, String>();
                    for (MonitorDataExporter.MonitorDataExportColumn monitorDataExportColumn : monitorDataExportColumns) {
                        String columnName = monitorDataExportColumn.columnName();
                        String columnNameForExport = monitorDataExportColumn.columnNameForExport();
                        Object columnValue = sourceValues.get(columnName);
                        if (this.monitorColumnRendererFormatter.shouldApplyRendererOrFormatter(columnName, columnValue)) {
                            columnValue = this.monitorColumnRendererFormatter.applyRendererOrFormatter(columnName, columnValue);
                        }
                        if (!this.useUtcDateFormat && columnValue != null && "date".equalsIgnoreCase(this.getOpenSearchColumnType(columnName))) {
                            Date date = this.getDateFromValue(columnValue);
                            if (date != null) {
                                SimpleDateFormat dateFormat = this.getDateFormat(columnName);
                                String formattedDate = dateFormat != null ? dateFormat.format(date) : this.defaultDateFormat.format(date);
                                jsonValues.put(columnNameForExport, formattedDate);
                                continue;
                            }
                            jsonValues.put(columnNameForExport, (String)columnValue);
                            continue;
                        }
                        jsonValues.put(columnNameForExport, (String)columnValue);
                    }
                    bw.write(mapper.writeValueAsString(jsonValues));
                    if (limit != null && ++rowIdx >= limit) {
                        LOGGER.info("Stop .... export limit of {} rows reached ({})", (Object)limit, (Object)rowIdx);
                        done = true;
                        break;
                    }
                    if ((long)rowIdx < totalCount) {
                        bw.write(",");
                        bw.newLine();
                    }
                    if (rowIdx % 5000 != 0) continue;
                    bw.flush();
                }
                if (done || (scrollResp = osClient.scroll(new SearchScrollRequest(scrollResp.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0) continue;
                LOGGER.info("Stop ... no more hits");
                done = true;
                break;
            }
            bw.newLine();
            bw.write("]");
            bw.newLine();
            bw.write("}");
        }
    }
}

