/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.module.monitor.MonitorModule;
import de.virtimo.bpc.module.monitor.api.service.MonitorService;
import de.virtimo.bpc.module.monitor.exception.IndexAccessNotAllowedException;
import de.virtimo.bpc.module.monitor.query.SessionBasedQuery;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class MonitorServiceImpl
implements MonitorService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(MonitorServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final Set<String> blockedIndexAndAliasNames;
    private Date blockedIndexAndAliasNamesState;

    public MonitorServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker(bundleContext, OpenSearchService.class);
        this.blockedIndexAndAliasNames = new HashSet<String>();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll((Object)this);
    }

    @Override
    public boolean isAccessible(String instanceId, Set<String> processes, UserSession userSession) throws ModuleInstanceNotFoundException, OpenSearchIndexNotFoundException, OpenSearchRelatedException, IOException, OpenSearchIndexMappingNotFoundException, IndexAccessNotAllowedException, ServiceNotFoundException {
        LOGGER.info("isAccessible instanceId={}, processes={}, userSession={}", (Object)instanceId, processes, (Object)userSession);
        ModuleInstance mi = MonitorModule.getInstance().getModuleInstance(instanceId);
        if (mi == null || !userSession.hasUseModuleInstanceRight(mi)) {
            throw new ModuleInstanceNotFoundException("monitor", instanceId);
        }
        return this.hasUserAccessToProcesses(userSession, mi, processes);
    }

    public boolean hasUserAccessToProcesses(UserSession userSession, ModuleInstance mi, Set<String> processes) throws IndexAccessNotAllowedException, OpenSearchRelatedException, IOException, OpenSearchIndexNotFoundException, OpenSearchIndexMappingNotFoundException, ServiceNotFoundException {
        LOGGER.info("hasUserAccessToProcesses userSession=..., mi=..., processes={}", processes);
        if (processes == null || processes.isEmpty()) {
            throw new IllegalArgumentException("No processes given.");
        }
        String index = mi.getConfiguration().getSettingValue("data_index").asString("").toLowerCase();
        if (!this.isIndexAccessAllowed(index)) {
            throw new IndexAccessNotAllowedException(index);
        }
        OpenSearchService openSearchService = (OpenSearchService)this.openSearchServiceTracker.getService();
        RestHighLevelClient osClient = openSearchService.getClient();
        BpcIndexMapping indexMapping = new BpcIndexMapping(openSearchService.getMappingMetaData(index));
        String idField = (String)mi.getConfiguration().getSetting("column_id").getValue();
        String idQueryField = indexMapping.getPreferredQueryFieldForIDs(idField);
        String dataFilterOperator = mi.getConfiguration().getSettingValue("data_filter_operator").asString("").toLowerCase();
        QueryBuilder query = new BpcQueryBuilder().addQueryBuilder(SessionBasedQuery.getQueryBuilder(userSession, mi.getConfiguration().getSettingValue("data_filter").asMap(null), dataFilterOperator)).addSkipPercolatorDocumentsQuery().addQueryBuilder((QueryBuilder)QueryBuilders.termsQuery((String)idQueryField, processes)).buildAsBoolFilterQuery();
        SearchRequest sr = new SearchRequest().indices(new String[]{index}).source(new SearchSourceBuilder().fetchSource(idField, null).size(10000).trackTotalHits(true).query(query));
        SearchResponse searchResponse = osClient.search(sr, RequestOptions.DEFAULT);
        long foundProcesses = searchResponse.getHits().getTotalHits().value;
        return (long)processes.size() == foundProcesses;
    }

    @Override
    public boolean isIndexAccessAllowed(String indexOrAliasName) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.debug("isIndexAccessAllowed indexOrAliasName={}", (Object)indexOrAliasName);
        if (StringUtil.isNullOrEmpty((String)indexOrAliasName)) {
            return false;
        }
        if (this.blockedIndexAndAliasNamesState == null) {
            this.updateBlockedIndexAndAliasNames();
        } else {
            Date now = new Date();
            long diff = now.getTime() - this.blockedIndexAndAliasNamesState.getTime();
            LOGGER.debug("Cache age of blockedIndexAndAliasNames {}", (Object)diff);
            long diffMinutes = diff / 60000L % 60L;
            if (diffMinutes >= 5L) {
                this.updateBlockedIndexAndAliasNames();
            }
        }
        return !this.blockedIndexAndAliasNames.contains(indexOrAliasName);
    }

    private void updateBlockedIndexAndAliasNames() throws ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.debug("updateBlockedIndexAndAliasNames");
        OpenSearchService openSearchService = (OpenSearchService)this.openSearchServiceTracker.getService();
        List<String> names = Arrays.asList("bpc-configuration");
        this.blockedIndexAndAliasNames.clear();
        for (String name : names) {
            LOGGER.debug("Get Indices and aliases for {}", (Object)name);
            this.blockedIndexAndAliasNames.add(name);
            Set aliases = openSearchService.getAliasesForIndexName(name);
            LOGGER.debug("Found aliases {}", (Object)String.join((CharSequence)", ", aliases));
            this.blockedIndexAndAliasNames.addAll(aliases);
            Set indices = openSearchService.getIndexNamesWithAlias(name);
            LOGGER.debug("Found indices {}", (Object)String.join((CharSequence)", ", indices));
            this.blockedIndexAndAliasNames.addAll(indices);
        }
        this.blockedIndexAndAliasNamesState = new Date();
    }
}

