/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.common.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.transaction.xa.XAResource;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionContextImpl;
import org.osgi.service.transaction.control.LocalResource;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionStatus;

public class NoTransactionContextImpl
extends AbstractTransactionContextImpl
implements TransactionContext {
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.WORKING);

    @Override
    public Object getTransactionKey() {
        return null;
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        throw new IllegalStateException("No transaction is active");
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        throw new IllegalStateException("No transaction is active");
    }

    @Override
    public TransactionStatus getTransactionStatus() {
        return TransactionStatus.NO_TRANSACTION;
    }

    @Override
    public void preCompletion(Runnable job) throws IllegalStateException {
        if (this.status.get() != Status.WORKING) {
            throw new IllegalStateException("The scoped work has returned. No more pre-completion callbacks can be registered");
        }
        this.preCompletion.add(job);
    }

    @Override
    public void postCompletion(Consumer<TransactionStatus> job) throws IllegalStateException {
        if (this.status.get() == Status.POST) {
            throw new IllegalStateException("Post completion callbacks have begun. No more post-completion callbacks can be registered");
        }
        this.postCompletion.add(job);
    }

    @Override
    public void registerXAResource(XAResource resource, String recoveryName) {
        throw new IllegalStateException("No transaction is active");
    }

    @Override
    public void registerLocalResource(LocalResource resource) {
        throw new IllegalStateException("No transaction is active");
    }

    @Override
    public boolean supportsXA() {
        return false;
    }

    @Override
    public boolean supportsLocal() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected boolean isAlive() {
        return this.status.get() == Status.WORKING;
    }

    @Override
    public void finish() {
        if (this.status.compareAndSet(Status.WORKING, Status.PRE)) {
            this.beforeCompletion(() -> {});
            this.status.set(Status.POST);
            this.afterCompletion(TransactionStatus.NO_TRANSACTION);
        }
    }

    @Override
    protected void safeSetRollbackOnly() {
    }

    private static enum Status {
        WORKING,
        PRE,
        POST;

    }
}

