/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.snapshots.SnapshotState;

public class BackupSnapshotInfoDTO
implements OpenSearchPluginDTO {
    private final String snapshotName;
    private final Instant startTime;
    private final SnapshotState state;
    private final boolean bpcConfigurationIndex;
    private final List<String> indices;
    private final Map<String, Object> exceptionAsResponseMap;

    public static BackupSnapshotInfoDTO createForExceptionAsResponseMap(Map<String, Object> exceptionAsResponseMap) {
        return new BackupSnapshotInfoDTO(null, null, null, false, null, exceptionAsResponseMap);
    }

    public BackupSnapshotInfoDTO(String snapshotName, Instant startTime, SnapshotState state, boolean bpcConfigurationIndex, List<String> indices, Map<String, Object> exceptionAsResponseMap) {
        this.snapshotName = snapshotName;
        this.startTime = startTime;
        this.state = state;
        this.bpcConfigurationIndex = bpcConfigurationIndex;
        this.indices = indices;
        this.exceptionAsResponseMap = exceptionAsResponseMap;
    }

    public BackupSnapshotInfoDTO(Map<String, Object> backupJobInfoData) {
        this.checkForWellKnownKeys(backupJobInfoData);
        Map exceptionAsResponseMap = MapUtil.getValueAsMap(backupJobInfoData, (String)"exceptionAsResponseMap", null);
        if (exceptionAsResponseMap != null && !exceptionAsResponseMap.isEmpty()) {
            this.snapshotName = null;
            this.startTime = null;
            this.state = null;
            this.bpcConfigurationIndex = false;
            this.indices = null;
            this.exceptionAsResponseMap = exceptionAsResponseMap;
        } else {
            this.snapshotName = MapUtil.getValueAsString(backupJobInfoData, (String)"snapshotName", null);
            this.startTime = MapUtil.getValueAsInstant(backupJobInfoData, (String)"startTime", null);
            this.state = SnapshotState.fromValue((byte)MapUtil.getValueAsByte(backupJobInfoData, (String)"state", (byte)0));
            this.bpcConfigurationIndex = MapUtil.getValueAsBoolean(backupJobInfoData, (String)"bpcConfigurationIndex", (boolean)false);
            this.indices = MapUtil.getValueAsList(backupJobInfoData, (String)"indices", null);
            this.exceptionAsResponseMap = null;
        }
    }

    private void checkForWellKnownKeys(Map<String, Object> serverData) {
        MapUtil.checkForWellKnownKeys(serverData, Set.of("snapshotName", "startTime", "state", "bpcConfigurationIndex", "indices", "exceptionAsResponseMap"));
    }

    public BackupSnapshotInfoDTO(StreamInput in) throws IOException {
        boolean hasException = in.readBoolean();
        if (hasException) {
            this.snapshotName = null;
            this.startTime = null;
            this.state = null;
            this.bpcConfigurationIndex = false;
            this.indices = null;
            this.exceptionAsResponseMap = in.readMap();
        } else {
            this.snapshotName = in.readString();
            this.startTime = in.readInstant();
            this.state = (SnapshotState)in.readEnum(SnapshotState.class);
            this.bpcConfigurationIndex = in.readBoolean();
            this.indices = in.readStringList();
            this.exceptionAsResponseMap = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.hasException()) {
            out.writeBoolean(true);
            out.writeMap(this.exceptionAsResponseMap);
        } else {
            out.writeBoolean(false);
            out.writeString(this.snapshotName);
            out.writeInstant(this.startTime);
            out.writeEnum((Enum)this.state);
            out.writeBoolean(this.bpcConfigurationIndex);
            out.writeStringCollection(this.indices);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.hasException()) {
            builder.field("exceptionAsResponseMap", this.exceptionAsResponseMap);
        } else {
            builder.field("snapshotName", this.snapshotName);
            builder.field("startTime", TimestampUtil.formatAsIsoInstantString((Instant)this.startTime));
            builder.field("state", this.state.value());
            builder.field("bpcConfigurationIndex", this.bpcConfigurationIndex);
            builder.field("indices", this.indices);
        }
        builder.endObject();
        return builder;
    }

    public static BackupSnapshotInfoDTO fromXContent(XContentParser parser) throws IOException {
        return new BackupSnapshotInfoDTO(parser.map());
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public SnapshotState getState() {
        return this.state;
    }

    public boolean isBpcConfigurationIndex() {
        return this.bpcConfigurationIndex;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public boolean hasException() {
        return this.exceptionAsResponseMap != null && !this.exceptionAsResponseMap.isEmpty();
    }

    public Map<String, Object> getExceptionAsResponseMap() {
        return this.exceptionAsResponseMap;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSnapshotInfoDTO that = (BackupSnapshotInfoDTO)o;
        return this.bpcConfigurationIndex == that.bpcConfigurationIndex && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.startTime, that.startTime) && this.state == that.state && Objects.equals(this.indices, that.indices) && Objects.equals(this.exceptionAsResponseMap, that.exceptionAsResponseMap);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotName, this.startTime, this.state, this.bpcConfigurationIndex, this.indices, this.exceptionAsResponseMap);
    }

    public String toString() {
        return "BackupSnapshotInfoDTO{snapshotName='" + this.snapshotName + "', startTime=" + this.startTime + ", state=" + this.state + ", bpcConfigurationIndex=" + this.bpcConfigurationIndex + ", indices=" + this.indices + ", exceptionAsResponseMap=" + this.exceptionAsResponseMap + "}";
    }
}

