/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.xcontent.ToXContent;

public class BackupSnapshotCreatedInfoWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "BackupSnapshotCreatedInfo:::";
    private final String communicationId;
    private final BackupSnapshotInfoDTO backupSnapshotInfo;
    private final Instant sendedAtInUtc;

    public BackupSnapshotCreatedInfoWebsocketMessage(String communicationId, BackupSnapshotInfoDTO backupSnapshotInfo) {
        this(communicationId, backupSnapshotInfo, TimestampUtil.nowInUtc());
    }

    public BackupSnapshotCreatedInfoWebsocketMessage(String communicationId, BackupSnapshotInfoDTO backupSnapshotInfo, Instant sendedAtInUtc) {
        this.communicationId = communicationId;
        this.backupSnapshotInfo = backupSnapshotInfo;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public BackupSnapshotCreatedInfoWebsocketMessage(Map<String, Object> msgMap) {
        this.checkForWellKnownKeys(msgMap);
        this.communicationId = MapUtil.getValueAsString(msgMap, (String)"communicationId", null);
        this.backupSnapshotInfo = new BackupSnapshotInfoDTO(MapUtil.getValueAsMap(msgMap, (String)"backupSnapshotInfo", null));
        this.sendedAtInUtc = MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc());
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("communicationId", "backupSnapshotInfo", "sendedAt"));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"communicationId", this.communicationId, "backupSnapshotInfo", JsonUtil.asMap((ToXContent)this.backupSnapshotInfo), "sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc)});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BackupSnapshotCreatedInfoWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new BackupSnapshotCreatedInfoWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + BackupSnapshotCreatedInfoWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public BackupSnapshotInfoDTO getBackupSnapshotInfo() {
        return this.backupSnapshotInfo;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "BackupSnapshotCreatedInfoWebsocketMessage{communicationId='" + this.communicationId + "', backupSnapshotInfo=" + this.backupSnapshotInfo + ", sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

