@echo off

rem This file should be placed in the same directory as Karaf and OpenSearch.
rem It will automatically be loaded by Karaf and OpenSearch on startup.

rem *****************
rem *** Java Home ***
rem *****************
rem The 'java_home_path_setter.cmd' (inubit installer) gets called to set the Java home path.
rem In case the file does not exist or you want to use a different Java home, you can overwrite it here.

rem set JAVA_HOME=<path to jvm>

rem ***********
rem *** RAM ***
rem ***********

rem *** OpenSearch ***
rem To avoid multiple xmx/xms params in your process list you could remove these params from opensearch/config/jvm.options
SET OPENSEARCH_JAVA_OPTS=%OPENSEARCH_JAVA_OPTS% -Xms1g -Xmx1g

rem *** Karaf ***
SET EXTRA_JAVA_OPTS=%EXTRA_JAVA_OPTS% -Xms128m -Xmx512m

rem ***************
rem *** Network ***
rem ***************

rem To change all ports by an offset you can change the PORT_OFFSET. For example PORT_OFFSET=10000 will add 10000 to all ports.
rem So the port 8181 will be 18181.
SET PORT_OFFSET=0

SET /a ORG_APACHE_KARAF_SHELL_SSHPORT=%PORT_OFFSET% + 8101
SET /a ORG_APACHE_KARAF_MANAGEMENT_RMIREGISTRYPORT=%PORT_OFFSET% + 1099
SET /a ORG_APACHE_KARAF_MANAGEMENT_RMISERVERPORT=%PORT_OFFSET% + 4444
SET /a ORG_OPS4J_PAX_WEB_ORG_OSGI_SERVICE_HTTP_PORT=%PORT_OFFSET% + 8181
SET /a ORG_OPS4J_PAX_WEB_ORG_OSGI_SERVICE_HTTP_PORT_SECURE=%PORT_OFFSET% + 8282
SET /a DE_VIRTIMO_BPC_CORE_DE_VIRTIMO_BPC_CORE_OPENSEARCH_PORT=%PORT_OFFSET% + 9200
SET /a DE_VIRTIMO_BPC_CORE_DE_VIRTIMO_BPC_CORE_OPENSEARCH_TRANSPORT_PORT=%PORT_OFFSET% + 9300
SET /a DE_VIRTIMO_BPC_CORE_DE_VIRTIMO_BPC_CORE_OPENSEARCH_WEBSOCKET_PORT=%PORT_OFFSET% + 9203

rem enable/disable HTTP (org.osgi.service.http.enabled)
rem SET ORG_OPS4J_PAX_WEB_ORG_OSGI_SERVICE_HTTP_ENABLED=false
rem enable/disable HTTPS (org.osgi.service.http.secure.enabled)
rem SET ORG_OPS4J_PAX_WEB_ORG_OSGI_SERVICE_HTTP_SECURE_ENABLED=true

rem *** OpenSearch Config Directory ***
rem by default, the configuration directory is in opensearch\config
rem You can change the config directory by setting this env variable (rel to OpenSearch-Home BPC_DIR\opensearch)
SET OPENSEARCH_PATH_CONF=..\opensearch_config

rem ****************************
rem pax-jdbc Features to install
rem ****************************

rem Usually they must be installed from the Karaf Shell, e.g.: feature:install pax-jdbc-oracle

rem You can automate this by providing the pax-jdbc features to install by a comma separated list.

rem Some of these pax-jdbc features try to download and install jdbc-drivers for you.
rem This is not always the driver version you need. In case you provide your own jdbc-driver,
rem then mark those entries with (*). Then those pax-jdbc features get installed when
rem your provided jdbc-driver is already installed as a wrapped bundle.
rem SET KARAF_PAX_JDBC_FEATURES_TO_INSTALL=pax-jdbc-oracle (*), pax-jdbc-sqlite, pax-jdbc-mssql (*), pax-jdbc-mariadb (*)

rem ****************************
rem Set custom jetty configuration, like HTTP headers
rem ****************************

rem You can modify the jetty configuration and keep them active during Karaf updates.
rem copy the KARAF/etc/jetty.xml to the same folder as bpc.env and uncomment the following line
rem SET ORG_OPS4J_PAX_WEB_ORG_OPS4J_PAX_WEB_CONFIG_FILE=${karaf.base}/../jetty.xml

rem ****************************
rem Karaf Log
rem ****************************
rem Changes for KARAF/etc/de.virtimo.bpc.decanter.appender.opensearch.cfg
rem See also https://docs.virtimo.net/de/bpc-docs/latest/core/admin/operation/karaf_log.html

rem SET DE_VIRTIMO_BPC_DECANTER_APPENDER_OPENSEARCH_ENABLED=true
rem SET DE_VIRTIMO_BPC_DECANTER_APPENDER_OPENSEARCH_CLEANUPPERIODINMINUTES=60
rem SET DE_VIRTIMO_BPC_DECANTER_APPENDER_OPENSEARCH_DELETEENTRIESOLDERTHAN=7 days ago

rem ****************************
rem Override Karaf Properties
rem ****************************

rem You can override any configuration using either environment variables or system properties.
rem You can use PID_PROPERTY=VALUE syntax for environment variable
rem For instance, the following statement will override value sshPort in etc/org.apache.karaf.shell.cfg:
rem SET ORG_APACHE_KARAF_SHELL_SSHPORT=8102
rem see also https://karaf.apache.org/manual/latest/#_environment_variables_system_properties

:: ****************************
:: Additional Karaf JVM Options
:: ****************************
SET EXTRA_JAVA_OPTS=%EXTRA_JAVA_OPTS% -Djava.security.properties=..\custom.java.security

:: ****************************
:: Additional OpenSearch JVM Options
:: ****************************
SET OPENSEARCH_JAVA_OPTS=%OPENSEARCH_JAVA_OPTS% -Djava.security.properties=..\custom.java.security

rem ****************************
rem Keystore and Truststore
rem ****************************

rem it is recommended to move your customized Karaf Keystore and Truststore files out of the Karaf and OpenSearch folders

rem Default Karaf locations:
rem   ./bpc/karaf/etc/virtimo/ssl/virtimo_keystore.jks
rem   ./bpc/karaf/etc/virtimo/ssl/virtimo_truststore.jks

rem Default OpenSearch locations:
rem   ./bpc/opensearch/config/virtimo/ssl/virtimo_keystore.jks
rem   ./bpc/opensearch/config/virtimo/ssl/virtimo_truststore.jks

rem Recommended new locations:
rem  ./bpc/ssl/virtimo_keystore.jks
rem  ./bpc/ssl/virtimo_truststore.jks

rem afterwards uncomment the following for Karaf
SET ORG_OPS4J_PAX_WEB_ORG_OPS4J_PAX_WEB_SSL_KEYSTORE=../ssl/virtimo_keystore.jks
SET ORG_OPS4J_PAX_WEB_ORG_OPS4J_PAX_WEB_SSL_TRUSTSTORE=../ssl/virtimo_truststore.jks

rem and create a symbolic link for OpenSearch (start the shell as administrator)
rem cd bpc && rmdir /s opensearch\config\virtimo\ssl && mklink /J opensearch\config\virtimo\ssl ssl
