/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.oracle.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.xa.client.OracleXADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class OracleDataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Properties props) throws SQLException {
        try {
            oracle.jdbc.pool.OracleDataSource ds = new oracle.jdbc.pool.OracleDataSource();
            this.setProperties((OracleDataSource)ds, props);
            return ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        try {
            OracleConnectionPoolDataSource ds = new OracleConnectionPoolDataSource();
            this.setProperties((OracleDataSource)ds, props);
            return ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        try {
            OracleXADataSource ds = new OracleXADataSource();
            this.setProperties((OracleDataSource)ds, props);
            return ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public Driver createDriver(Properties props) throws SQLException {
        return new OracleDriver();
    }

    private void setProperties(OracleDataSource ds, Properties properties) throws Exception {
        String databaseName;
        Properties props = (Properties)properties.clone();
        String url = (String)props.remove("url");
        if (url != null) {
            ds.setURL(url);
        }
        if ((databaseName = (String)props.remove("databaseName")) == null && url == null) {
            throw new SQLException("missing required property databaseName");
        }
        ds.setDatabaseName(databaseName);
        String serverName = (String)props.remove("serverName");
        ds.setServerName(serverName);
        String portNumber = (String)props.remove("portNumber");
        if (portNumber != null) {
            int portNum = Integer.parseInt(portNumber);
            ds.setPortNumber(portNum);
        }
        String user = (String)props.remove("user");
        ds.setUser(user);
        String password = (String)props.remove("password");
        ds.setPassword(password);
        if (!props.isEmpty()) {
            BeanConfig.configure((Object)ds, props);
        }
    }
}

