/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.internal;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Deque;
import java.util.LinkedList;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class JdbcConnector
implements Closeable {
    private CommonDataSource datasource;
    private Connection connection;
    private Deque<AutoCloseable> resources;

    public JdbcConnector(BundleContext bundleContext, ServiceReference<?> reference) {
        this.datasource = (CommonDataSource)bundleContext.getService(reference);
        this.resources = new LinkedList<AutoCloseable>();
        this.resources.addFirst(() -> bundleContext.ungetService(reference));
    }

    public Connection connect() throws SQLException {
        if (this.connection == null) {
            if (this.datasource instanceof DataSource) {
                this.connection = ((DataSource)this.datasource).getConnection();
            } else if (this.datasource instanceof XADataSource) {
                this.connection = this.register(((XADataSource)this.datasource).getXAConnection()).getConnection();
            } else {
                throw new IllegalStateException("Datasource is not an instance of DataSource nor XADataSource");
            }
            this.register(this.connection);
        }
        return this.connection;
    }

    public Statement createStatement() throws SQLException {
        return this.register(this.connect().createStatement());
    }

    public <T extends AutoCloseable> T register(T closeable) {
        this.resources.addFirst(closeable);
        return closeable;
    }

    public XAConnection register(XAConnection closeable) {
        this.register(closeable::close);
        return closeable;
    }

    @Override
    public void close() {
        for (AutoCloseable closeable : this.resources) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

