/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.command;

import org.apache.karaf.jndi.JndiService;
import org.apache.karaf.jndi.command.completers.ContextsCompleter;
import org.apache.karaf.jndi.command.completers.ServicesIdCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="jndi", name="bind", description="Bind an OSGi service in the JNDI context")
@Service
public class BindCommand
implements Action {
    @Argument(index=0, name="service", description="The ID of the OSGi service to bind", required=true, multiValued=false)
    @Completion(value=ServicesIdCompleter.class)
    Long serviceId;
    @Argument(index=1, name="name", description="The JNDI name to bind the OSGi service", required=true, multiValued=false)
    @Completion(value=ContextsCompleter.class)
    String name;
    @Reference
    JndiService jndiService;

    public Object execute() throws Exception {
        this.jndiService.bind(this.serviceId, this.name);
        return null;
    }
}

