/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BackupJobInfoDTO
implements OpenSearchPluginDTO {
    private final String backupJobIdentifier;
    private final boolean enabled;
    private final long intervalInSeconds;
    private final Set<String> indicesToBackup;
    private final long timestampOfLastestBackup;
    private final long timestampOfNextBackup;
    private final boolean queued;
    private final boolean scheduled;
    private final long nextCheckStartsInSeconds;

    public BackupJobInfoDTO(String backupJobIdentifier, boolean enabled, long intervalInSeconds, Set<String> indicesToBackup, long timestampOfLastestBackup, long timestampOfNextBackup, boolean queued, boolean scheduled, long nextCheckStartsInSeconds) {
        this.backupJobIdentifier = backupJobIdentifier;
        this.enabled = enabled;
        this.intervalInSeconds = intervalInSeconds;
        this.indicesToBackup = indicesToBackup != null ? new HashSet<String>(indicesToBackup) : new HashSet();
        this.timestampOfLastestBackup = timestampOfLastestBackup;
        this.timestampOfNextBackup = timestampOfNextBackup;
        this.queued = queued;
        this.scheduled = scheduled;
        this.nextCheckStartsInSeconds = nextCheckStartsInSeconds;
    }

    public BackupJobInfoDTO(Map<String, Object> backupJobInfoData) {
        this.checkForWellKnownKeys(backupJobInfoData);
        this.backupJobIdentifier = MapUtil.getValueAsString(backupJobInfoData, (String)"backupJobIdentifier", null);
        this.enabled = MapUtil.getValueAsBoolean(backupJobInfoData, (String)"enabled", (boolean)false);
        this.intervalInSeconds = MapUtil.getValueAsLong(backupJobInfoData, (String)"intervalInSeconds", (long)0L);
        this.indicesToBackup = MapUtil.getValueAsSet(backupJobInfoData, (String)"indicesToBackup", null);
        this.timestampOfLastestBackup = MapUtil.getValueAsLong(backupJobInfoData, (String)"timestampOfLastestBackup", (long)-1L);
        this.timestampOfNextBackup = MapUtil.getValueAsLong(backupJobInfoData, (String)"timestampOfNextBackup", (long)-1L);
        this.queued = MapUtil.getValueAsBoolean(backupJobInfoData, (String)"queued", (boolean)false);
        this.scheduled = MapUtil.getValueAsBoolean(backupJobInfoData, (String)"scheduled", (boolean)false);
        this.nextCheckStartsInSeconds = MapUtil.getValueAsLong(backupJobInfoData, (String)"nextCheckStartsInSeconds", (long)-1L);
    }

    private void checkForWellKnownKeys(Map<String, Object> serverData) {
        MapUtil.checkForWellKnownKeys(serverData, Set.of("backupJobIdentifier", "enabled", "intervalInSeconds", "indicesToBackup", "timestampOfLastestBackup", "timestampOfNextBackup", "queued", "scheduled", "nextCheckStartsInSeconds"));
    }

    public BackupJobInfoDTO(StreamInput in) throws IOException {
        this.backupJobIdentifier = in.readString();
        this.enabled = in.readBoolean();
        this.intervalInSeconds = in.readLong();
        this.indicesToBackup = Sets.newHashSet((Object[])in.readStringArray());
        this.timestampOfLastestBackup = in.readLong();
        this.timestampOfNextBackup = in.readLong();
        this.queued = in.readBoolean();
        this.scheduled = in.readBoolean();
        this.nextCheckStartsInSeconds = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.backupJobIdentifier);
        out.writeBoolean(this.enabled);
        out.writeLong(this.intervalInSeconds);
        out.writeStringCollection(this.indicesToBackup);
        out.writeLong(this.timestampOfLastestBackup);
        out.writeLong(this.timestampOfNextBackup);
        out.writeBoolean(this.queued);
        out.writeBoolean(this.scheduled);
        out.writeLong(this.nextCheckStartsInSeconds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("backupJobIdentifier", this.backupJobIdentifier);
        builder.field("enabled", this.enabled);
        builder.field("intervalInSeconds", this.intervalInSeconds);
        builder.field("indicesToBackup", this.indicesToBackup);
        builder.field("timestampOfLastestBackup", this.timestampOfLastestBackup);
        builder.field("timestampOfNextBackup", this.timestampOfNextBackup);
        builder.field("queued", this.queued);
        builder.field("scheduled", this.scheduled);
        builder.field("nextCheckStartsInSeconds", this.nextCheckStartsInSeconds);
        builder.endObject();
        return builder;
    }

    public static BackupJobInfoDTO fromXContent(XContentParser parser) throws IOException {
        return new BackupJobInfoDTO(parser.map());
    }

    public String getBackupJobIdentifier() {
        return this.backupJobIdentifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Set<String> getIndicesToBackup() {
        return this.indicesToBackup;
    }

    public long getTimestampOfLastestBackup() {
        return this.timestampOfLastestBackup;
    }

    public long getTimestampOfNextBackup() {
        return this.timestampOfNextBackup;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public long getNextCheckStartsInSeconds() {
        return this.nextCheckStartsInSeconds;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobInfoDTO that = (BackupJobInfoDTO)o;
        return this.enabled == that.enabled && this.intervalInSeconds == that.intervalInSeconds && this.timestampOfLastestBackup == that.timestampOfLastestBackup && this.timestampOfNextBackup == that.timestampOfNextBackup && this.queued == that.queued && this.scheduled == that.scheduled && this.nextCheckStartsInSeconds == that.nextCheckStartsInSeconds && Objects.equals(this.backupJobIdentifier, that.backupJobIdentifier) && Objects.equals(this.indicesToBackup, that.indicesToBackup);
    }

    public int hashCode() {
        return Objects.hash(this.backupJobIdentifier, this.enabled, this.intervalInSeconds, this.indicesToBackup, this.timestampOfLastestBackup, this.timestampOfNextBackup, this.queued, this.scheduled, this.nextCheckStartsInSeconds);
    }

    public String toString() {
        return "BackupJobInfoDTO{backupJobIdentifier='" + this.backupJobIdentifier + "', enabled=" + this.enabled + ", intervalInSeconds=" + this.intervalInSeconds + ", indicesToBackup=" + this.indicesToBackup + ", timestampOfLastestBackup=" + this.timestampOfLastestBackup + ", timestampOfNextBackup=" + this.timestampOfNextBackup + ", queued=" + this.queued + ", scheduled=" + this.scheduled + ", nextCheckStartsInSeconds=" + this.nextCheckStartsInSeconds + "}";
    }
}

