/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public abstract class ValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected ValuesSourceConfig config;

    public ValuesSourceAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.config = config;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (!this.config.hasValues()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return this.doCreateInternal(searchContext, parent, cardinality, metadata);
    }

    protected abstract Aggregator createUnmapped(SearchContext var1, Aggregator var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(SearchContext var1, Aggregator var2, CardinalityUpperBound var3, Map<String, Object> var4) throws IOException;

    @Override
    public String getStatsSubtype() {
        return this.config.valueSourceType().typeName();
    }

    public String getField() {
        return this.config.fieldContext() != null ? this.config.fieldContext().field() : null;
    }
}

