/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;

public class ReplicationJobStatsRequestWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "ReplicationJobStatsRequest:::";
    private final String communicationId;
    private final Instant sendedAtInUtc;

    public ReplicationJobStatsRequestWebsocketMessage(String communicationId) {
        this(communicationId, TimestampUtil.nowInUtc());
    }

    public ReplicationJobStatsRequestWebsocketMessage(String communicationId, Instant sendedAtInUtc) {
        this.communicationId = communicationId;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public ReplicationJobStatsRequestWebsocketMessage(Map<String, Object> msgMap) {
        this(MapUtil.getValueAsString(msgMap, (String)"communicationId", null), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("communicationId", "sendedAt"));
    }

    private Map<String, Object> asMap() {
        return MapUtil.mapOf((Object[])new Object[]{"communicationId", this.communicationId, "sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc)});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static ReplicationJobStatsRequestWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new ReplicationJobStatsRequestWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + ReplicationJobStatsRequestWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "ReplicationJobStatsRequestWebsocketMessage{communicationId='" + this.communicationId + "', sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

