/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import oracle.jdbc.driver.DMSFactory;
import oracle.net.nt.MetricsEnabledSSLSocketWrapper;

class MetricsEnabledSSLSocketFactoryWrapper
extends SSLSocketFactory {
    DMSFactory.DMSNoun base;
    DMSFactory.DMSNoun waitnoun;
    DMSFactory.DMSPhase waitEvent;
    SSLSocketFactory factory;

    MetricsEnabledSSLSocketFactoryWrapper() {
        this.factory = null;
    }

    MetricsEnabledSSLSocketFactoryWrapper(SSLSocketFactory factory, DMSFactory.DMSNoun dmsParent) {
        this.factory = factory;
        this.waitEvent = DMSFactory.getInstance().createPhaseEvent(dmsParent, "DBWaitTime", "Time spent waiting for DB");
        this.waitEvent.deriveMetric(DMSFactory.SensorIntf_all);
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.factory.createSocket();
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.factory.createSocket(host, port);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException, UnknownHostException {
        Socket socket = this.factory.createSocket(address, port);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.factory.createSocket(address, port, localAddress, localPort);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.factory.createSocket(host, port, localHost, localPort);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.factory.createSocket(s, host, port, autoClose);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

