/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleJdbc2SQLInput
implements SQLInput {
    private int index;
    private Datum[] attributes;
    private Map map;
    private oracle.jdbc.OracleConnection conn;

    public OracleJdbc2SQLInput(Datum[] attributes, Map map, oracle.jdbc.OracleConnection conn) {
        this.attributes = attributes;
        this.map = map;
        this.conn = conn;
        this.index = 0;
    }

    @Override
    public String readString() throws SQLException {
        String ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].stringValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        boolean ret = false;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].booleanValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public byte readByte() throws SQLException {
        byte ret = 0;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].byteValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public short readShort() throws SQLException {
        long result = this.readLong();
        if (result > 65537L || result < -65538L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "readShort").fillInStackTrace();
        }
        return (short)result;
    }

    @Override
    public int readInt() throws SQLException {
        int ret = 0;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].intValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public long readLong() throws SQLException {
        long ret = 0L;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].longValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public float readFloat() throws SQLException {
        float ret = 0.0f;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].floatValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public double readDouble() throws SQLException {
        double ret = 0.0;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].doubleValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].bigDecimalValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        byte[] ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof RAW) {
                    ret = ((RAW)this.attributes[this.index]).shareBytes();
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    @Override
    public Date readDate() throws SQLException {
        Date ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].dateValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public Time readTime() throws SQLException {
        Time ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].timeValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        Timestamp ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].timestampValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Reader ret = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                ret = datum.characterStreamValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        InputStream ret = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                ret = datum.asciiStreamValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        InputStream ret = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                ret = datum.binaryStreamValue();
            }
        }
        finally {
            ++this.index;
        }
        return ret;
    }

    @Override
    public Object readObject() throws SQLException {
        Datum datum = (Datum)this.readOracleObject();
        Object ret = null;
        if (datum != null) {
            ret = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(this.map) : datum.toJdbc();
        }
        return ret;
    }

    @Override
    public Ref readRef() throws SQLException {
        return this.readREF();
    }

    @Override
    public Blob readBlob() throws SQLException {
        return this.readBLOB();
    }

    @Override
    public Clob readClob() throws SQLException {
        return this.readCLOB();
    }

    @Override
    public Array readArray() throws SQLException {
        return this.readARRAY();
    }

    public Struct readStruct() throws SQLException {
        return this.readSTRUCT();
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.index == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
        }
        boolean ret = this.attributes[this.index - 1] == null;
        return ret;
    }

    public Object readOracleObject() throws SQLException {
        return this.attributes[this.index++];
    }

    public NUMBER readNUMBER() throws SQLException {
        NUMBER ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof NUMBER) {
                    ret = (NUMBER)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public CHAR readCHAR() throws SQLException {
        CHAR ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof CHAR) {
                    ret = (CHAR)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public DATE readDATE() throws SQLException {
        DATE ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof DATE) {
                    ret = (DATE)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public BFILE readBFILE() throws SQLException {
        BFILE ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof BFILE) {
                    ret = (BFILE)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public BLOB readBLOB() throws SQLException {
        BLOB ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof BLOB) {
                    ret = (BLOB)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public CLOB readCLOB() throws SQLException {
        CLOB ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof CLOB) {
                    ret = (CLOB)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public RAW readRAW() throws SQLException {
        RAW ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof RAW) {
                    ret = (RAW)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public REF readREF() throws SQLException {
        REF ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof REF) {
                    ret = (REF)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public ROWID readROWID() throws SQLException {
        ROWID ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof ROWID) {
                    ret = (ROWID)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public ARRAY readARRAY() throws SQLException {
        ARRAY ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof ARRAY) {
                    ret = (ARRAY)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    public STRUCT readSTRUCT() throws SQLException {
        STRUCT ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof STRUCT) {
                    ret = (STRUCT)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    @Override
    public URL readURL() throws SQLException {
        SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
        ex.fillInStackTrace();
        throw ex;
    }

    @Override
    public NClob readNClob() throws SQLException {
        NCLOB ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof NCLOB) {
                    ret = (NCLOB)this.attributes[this.index];
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    @Override
    public String readNString() throws SQLException {
        return this.readString();
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        SQLXML ret;
        block4: {
            ret = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof SQLXML) {
                    ret = (SQLXML)((Object)this.attributes[this.index]);
                    break block4;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null).fillInStackTrace();
            }
            finally {
                ++this.index;
            }
        }
        return ret;
    }

    @Override
    public RowId readRowId() throws SQLException {
        return this.readROWID();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

