/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.marshaller.json;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.karaf.decanter.api.marshaller.Unmarshaller;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"dataFormat=json"})
public class JsonUnmarshaller
implements Unmarshaller {
    public Map<String, Object> unmarshal(InputStream in) {
        JsonReader reader = Json.createReader((InputStream)in);
        JsonObject jsonO = reader.readObject();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : jsonO.keySet()) {
            map.put(key, this.unmarshalAttribute((JsonValue)jsonO.get((Object)key)));
        }
        reader.close();
        return map;
    }

    private Object unmarshalAttribute(JsonValue value) {
        if (value instanceof JsonNumber) {
            JsonNumber num = (JsonNumber)value;
            return num.isIntegral() ? Long.valueOf(num.longValue()) : num.bigDecimalValue();
        }
        if (value instanceof JsonString) {
            return ((JsonString)value).getString();
        }
        if (value instanceof JsonObject) {
            return this.build((JsonObject)value);
        }
        if (value instanceof JsonArray) {
            return this.build((JsonArray)value);
        }
        return null;
    }

    private Map<String, Object> build(JsonObject value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : value.entrySet()) {
            map.put((String)entry.getKey(), this.unmarshalAttribute((JsonValue)entry.getValue()));
        }
        return map;
    }

    private List<Object> build(JsonArray value) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonValue jsonValue : value) {
            list.add(this.unmarshalAttribute(jsonValue));
        }
        return list;
    }
}

