/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.TrustManagerFactory;
import org.opensearch.OpenSearchException;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.security.ssl.config.KeyStoreUtils;

public interface TrustStoreConfiguration {
    public static final TrustStoreConfiguration EMPTY_CONFIGURATION = new TrustStoreConfiguration(){

        @Override
        public Path file() {
            return null;
        }

        @Override
        public List<Certificate> loadCertificates() {
            return List.of();
        }

        @Override
        public KeyStore createTrustStore() {
            return null;
        }

        @Override
        public TrustManagerFactory createTrustManagerFactory(boolean validateCertificates) {
            return null;
        }
    };

    public Path file();

    public List<Certificate> loadCertificates();

    default public TrustManagerFactory createTrustManagerFactory(boolean validateCertificates) {
        KeyStore trustStore = this.createTrustStore();
        if (validateCertificates) {
            KeyStoreUtils.validateKeyStoreCertificates(trustStore);
        }
        return this.buildTrustManagerFactory(trustStore);
    }

    default public TrustManagerFactory buildTrustManagerFactory(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory;
        }
        catch (GeneralSecurityException e) {
            throw new OpenSearchException("Couldn't initialize TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    public KeyStore createTrustStore();

    public static final class PemTrustStoreConfiguration
    implements TrustStoreConfiguration {
        private final Path path;

        public PemTrustStoreConfiguration(Path path) {
            this.path = path;
        }

        @Override
        public List<Certificate> loadCertificates() {
            return Stream.of(KeyStoreUtils.x509Certificates(this.path)).map(c -> new Certificate((X509Certificate)c, false)).collect(Collectors.toList());
        }

        @Override
        public Path file() {
            return this.path;
        }

        @Override
        public KeyStore createTrustStore() {
            return KeyStoreUtils.newTrustStoreFromPem(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PemTrustStoreConfiguration that = (PemTrustStoreConfiguration)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hashCode(this.path);
        }
    }

    public static final class JdkTrustStoreConfiguration
    implements TrustStoreConfiguration {
        private final Path path;
        private final String type;
        private final String alias;
        private final char[] password;

        public JdkTrustStoreConfiguration(Path path, String type, String alias, char[] password) {
            this.path = path;
            this.type = type;
            this.alias = alias;
            this.password = password;
        }

        @Override
        public List<Certificate> loadCertificates() {
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(this.path, this.type, this.password);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            try {
                if (this.alias != null) {
                    listBuilder.add((Object)new Certificate((X509Certificate)keyStore.getCertificate(this.alias), this.type, this.alias, false));
                } else {
                    for (String a : Collections.list(keyStore.aliases())) {
                        java.security.cert.Certificate c;
                        if (!keyStore.isCertificateEntry(a) || !((c = keyStore.getCertificate(a)) instanceof X509Certificate)) continue;
                        listBuilder.add((Object)new Certificate((X509Certificate)c, this.type, a, false));
                    }
                }
                ImmutableList list = listBuilder.build();
                if (list.isEmpty()) {
                    throw new OpenSearchException("The file " + String.valueOf(this.path) + " does not contain any certificates", new Object[0]);
                }
                return listBuilder.build();
            }
            catch (GeneralSecurityException e) {
                throw new OpenSearchException("Couldn't load certificates from file " + String.valueOf(this.path), (Throwable)e, new Object[0]);
            }
        }

        @Override
        public Path file() {
            return this.path;
        }

        @Override
        public KeyStore createTrustStore() {
            return KeyStoreUtils.loadTrustStore(this.path, this.type, this.alias, this.password);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JdkTrustStoreConfiguration that = (JdkTrustStoreConfiguration)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.alias, that.alias) && Objects.deepEquals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.type, this.alias, Arrays.hashCode(this.password));
        }
    }
}

