/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BackupJobDeleteActionDTO
implements OpenSearchPluginDTO {
    private final String backupJobIdentifier;
    private final String initiatedOnServerUUID;
    private final String initiatedByUser;

    public BackupJobDeleteActionDTO(String backupJobIdentifier, String initiatedOnServerUUID, String initiatedByUser) {
        Objects.requireNonNull(backupJobIdentifier, "backupJobIdentifier cannot be null");
        Objects.requireNonNull(initiatedOnServerUUID, "initiatedOnServerUUID cannot be null");
        this.backupJobIdentifier = backupJobIdentifier;
        this.initiatedOnServerUUID = initiatedOnServerUUID;
        this.initiatedByUser = initiatedByUser;
    }

    public BackupJobDeleteActionDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"backupJobIdentifier", null), MapUtil.getValueAsString(actionMap, (String)"initiatedOnServerUUID", null), MapUtil.getValueAsString(actionMap, (String)"initiatedByUser", null));
        this.checkForWellKnownKeys(actionMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> actionMap) {
        MapUtil.checkForWellKnownKeys(actionMap, Set.of("backupJobIdentifier", "initiatedOnServerUUID", "initiatedByUser"));
    }

    public BackupJobDeleteActionDTO(StreamInput in) throws IOException {
        this.backupJobIdentifier = in.readString();
        this.initiatedOnServerUUID = in.readString();
        this.initiatedByUser = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.backupJobIdentifier);
        out.writeString(this.initiatedOnServerUUID);
        out.writeOptionalString(this.initiatedByUser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("backupJobIdentifier", this.backupJobIdentifier);
        builder.field("initiatedOnServerUUID", this.initiatedOnServerUUID);
        builder.field("initiatedByUser", this.initiatedByUser);
        builder.endObject();
        return builder;
    }

    public BackupJobDeleteActionDTO fromXContent(XContentParser parser) throws IOException {
        return new BackupJobDeleteActionDTO(parser.map());
    }

    public String getBackupJobIdentifier() {
        return this.backupJobIdentifier;
    }

    public String getInitiatedOnServerUUID() {
        return this.initiatedOnServerUUID;
    }

    public boolean isInitiatedByUser() {
        return !StringUtil.isNullOrEmpty((String)this.initiatedByUser);
    }

    public String getInitiatedByUser() {
        return this.initiatedByUser;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobDeleteActionDTO that = (BackupJobDeleteActionDTO)o;
        return Objects.equals(this.backupJobIdentifier, that.backupJobIdentifier) && Objects.equals(this.initiatedOnServerUUID, that.initiatedOnServerUUID) && Objects.equals(this.initiatedByUser, that.initiatedByUser);
    }

    public int hashCode() {
        return Objects.hash(this.backupJobIdentifier, this.initiatedOnServerUUID, this.initiatedByUser);
    }

    public String toString() {
        return "BackupJobDeleteActionDTO{backupJobIdentifier='" + this.backupJobIdentifier + "', initiatedOnServerUUID='" + this.initiatedOnServerUUID + "', initiatedByUser='" + this.initiatedByUser + "'}";
    }
}

