/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobsDTO
implements OpenSearchPluginDTO,
Iterable<ReplicationJobDTO> {
    private final List<ReplicationJobDTO> replicationJobs = new ArrayList<ReplicationJobDTO>();

    public ReplicationJobsDTO() {
    }

    public ReplicationJobsDTO(Map<String, Object> replicationJobsMap) {
        this();
        this.checkForWellKnownKeys(replicationJobsMap);
        this.replicationJobs.addAll(MapUtil.getArrayValueAsListOfObjects(replicationJobsMap, (String)"entries", ReplicationJobDTO.class));
    }

    private void checkForWellKnownKeys(Map<String, Object> replicationJobsMap) {
        MapUtil.checkForWellKnownKeys(replicationJobsMap, Set.of("entries"));
    }

    public ReplicationJobsDTO(StreamInput in) throws IOException {
        this();
        this.replicationJobs.addAll(in.readList(ReplicationJobDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.replicationJobs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("entries");
        for (ReplicationJobDTO replicationJob : this.replicationJobs) {
            replicationJob.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static ReplicationJobsDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobsDTO(parser.map());
    }

    public List<ReplicationJobDTO> getReplicationJobs() {
        return this.replicationJobs;
    }

    public void add(ReplicationJobDTO replicationJob) {
        if (replicationJob != null) {
            this.replicationJobs.add(replicationJob);
        }
    }

    @Override
    public Iterator<ReplicationJobDTO> iterator() {
        return this.replicationJobs.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobsDTO that = (ReplicationJobsDTO)o;
        return Objects.equals(this.replicationJobs, that.replicationJobs);
    }

    public int hashCode() {
        return Objects.hash(this.replicationJobs);
    }

    public String toString() {
        return "ReplicationJobsDTO{replicationJobs=" + this.replicationJobs + "}";
    }
}

