/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopActions;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobs
implements Iterable<ReplicationJob>,
OpenSearchPluginDTO {
    private static final Logger LOGGER = Loggers.getLogger(ReplicationJobs.class, (String[])new String[]{"os-bpc-plugin"});
    private final Map<String, ReplicationJob> replicationJobs = new TreeMap<String, ReplicationJob>();
    private long lastModifiedTimestamp = ReplicationJob.currentTimestamp();
    private static final Object REPLICATION_JOBS_LOCK = new Object();

    public ReplicationJobs() {
    }

    public ReplicationJobs(Map<String, Object> replicationJobsMap) {
        this();
        this.checkForWellKnownKeys(replicationJobsMap);
        Set jobs = MapUtil.getArrayValueAsSetOfObjects(replicationJobsMap, (String)"entries", ReplicationJob.class);
        for (ReplicationJob job : jobs) {
            this.replicationJobs.put(job.getId(), job);
        }
        this.lastModifiedTimestamp = MapUtil.getValueAsLong(replicationJobsMap, (String)"lastModifiedTimestamp", (long)ReplicationJob.currentTimestamp());
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("entries", "lastModifiedTimestamp"));
    }

    public ReplicationJobs(StreamInput in) throws IOException {
        this();
        this.replicationJobs.putAll(in.readMap(StreamInput::readString, ReplicationJob::new));
        this.lastModifiedTimestamp = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.replicationJobs, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        out.writeLong(this.lastModifiedTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            builder.startObject();
            builder.startArray("entries");
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                replicationJob.toXContent(builder, params);
            }
            builder.endArray();
            builder.field("lastModifiedTimestamp", this.lastModifiedTimestamp);
            builder.endObject();
            return builder;
        }
    }

    public static ReplicationJobs fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobs(parser.map());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModifiedTimestamp() {
        LOGGER.debug("getLastModifiedTimestamp");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            long lastModifiedOfReplicationJobs = 0L;
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                lastModifiedOfReplicationJobs = Math.max(lastModifiedOfReplicationJobs, replicationJob.getLastModifiedTimestamp());
            }
            return Math.max(lastModifiedOfReplicationJobs, this.lastModifiedTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this.replicationJobs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this.replicationJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            this.replicationJobs.clear();
            this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ReplicationJob replicationJob) {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (replicationJob != null) {
                this.replicationJobs.put(replicationJob.getId(), replicationJob);
                this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationJob getById(String replicationJobId) {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this.replicationJobs.get(replicationJobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getReplicationJobIDs() {
        LOGGER.debug("getReplicationJobIDs");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return new HashSet<String>(this.replicationJobs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUsedServerUUIDs() {
        LOGGER.debug("getUsedServerUUIDs");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this._getUsedServerUUIDs();
        }
    }

    private Set<String> _getUsedServerUUIDs() {
        LOGGER.debug("_getUsedServerUUIDs");
        HashSet<String> result = new HashSet<String>();
        for (ReplicationJob replicationJob : this.replicationJobs.values()) {
            String serverUUID = replicationJob.getServerUUID();
            if (serverUUID == null) continue;
            result.add(serverUUID);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReplicationJob> getReplicationJobsByServerUUIDs(Set<String> serverUUIDs) {
        LOGGER.debug("getReplicationJobsByServerUUIDs serverUUIDs={}", serverUUIDs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this._getReplicationJobsByServerUUIDs(serverUUIDs);
        }
    }

    private Set<ReplicationJob> _getReplicationJobsByServerUUIDs(Set<String> serverUUIDs) {
        LOGGER.debug("_getReplicationJobsByServerUUIDs serverUUIDs={}", serverUUIDs);
        HashSet<ReplicationJob> result = new HashSet<ReplicationJob>();
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                if (!serverUUIDs.contains(replicationJob.getServerUUID())) continue;
                result.add(replicationJob);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReplicationJob> getReplicationJobsByServerUUID(String serverUUID) {
        LOGGER.debug("getReplicationJobsByServerUUID serverUUID={}", (Object)serverUUID);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            HashSet<ReplicationJob> result = new HashSet<ReplicationJob>();
            if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
                for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                    if (!serverUUID.equals(replicationJob.getServerUUID())) continue;
                    result.add(replicationJob);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplicationJob> getReplicationJobsByState(ReplicationJob.State state) {
        LOGGER.debug("getReplicationJobsByState state={}", (Object)state);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            ArrayList<ReplicationJob> result = new ArrayList<ReplicationJob>();
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                if (!replicationJob.isInState(state)) continue;
                result.add(replicationJob);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplicationJob> getReplicationJobsByStates(List<ReplicationJob.State> states) {
        LOGGER.debug("getReplicationJobsByStates states={}", states);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            ArrayList<ReplicationJob> result = new ArrayList<ReplicationJob>();
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                if (!replicationJob.isInState(states)) continue;
                result.add(replicationJob);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> evaluateRemovedServerUUIDs(Set<String> serverUUIDs) {
        LOGGER.debug("evaluateRemovedServerUUIDs serverUUIDs={}", serverUUIDs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            Set<String> currentlyUsedServerUUIDs = this._getUsedServerUUIDs();
            HashSet<String> removedServerUUIDs = new HashSet<String>();
            for (String currentlyUsedServerUUID : currentlyUsedServerUUIDs) {
                if (serverUUIDs != null && serverUUIDs.contains(currentlyUsedServerUUID)) continue;
                removedServerUUIDs.add(currentlyUsedServerUUID);
            }
            return removedServerUUIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThoseAsStoppedUsingServerUUIDs(Set<String> removedServerUUIDs) {
        LOGGER.debug("setThoseAsStoppedUsingServerUUIDs removedServerUUIDs={}", removedServerUUIDs);
        if (removedServerUUIDs == null || removedServerUUIDs.isEmpty()) {
            return;
        }
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            Set<ReplicationJob> replicationJobsOfRemovedServerUUIDs = this._getReplicationJobsByServerUUIDs(removedServerUUIDs);
            for (ReplicationJob replicationJob : replicationJobsOfRemovedServerUUIDs) {
                replicationJob.setAsStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithStopActions(ReplicationJobStopActions stopActions) {
        LOGGER.debug("updateWithStopActions stopActions={}", (Object)stopActions);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (stopActions != null) {
                for (ReplicationJobStopAction stopAction : stopActions) {
                    ReplicationJob replicationJob;
                    if (stopAction == null || (replicationJob = this.replicationJobs.get(stopAction.getReplicationJobId())) == null || replicationJob.isInState(ReplicationJob.State.STOPPING)) continue;
                    replicationJob.setAsStopped();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithStartActions(ReplicationJobStartActions startActions) {
        LOGGER.debug("updateWithStartActions startActions={}", (Object)startActions);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (startActions != null) {
                for (ReplicationJobStartAction startAction : startActions) {
                    ReplicationJob replicationJob;
                    if (startAction == null || (replicationJob = this.replicationJobs.get(startAction.getReplicationJobId())) == null || replicationJob.isInState(ReplicationJob.State.STARTING)) continue;
                    replicationJob.setAsRunningOnServer(startAction.getServerUUID());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithLatestJobs(ReplicationJobs fromReplicationJobs) {
        LOGGER.debug("updateWithLatestJobs fromReplicationJobs={}", (Object)fromReplicationJobs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (fromReplicationJobs != null) {
                for (ReplicationJob fromJob : fromReplicationJobs) {
                    ReplicationJob existingJob = this.replicationJobs.get(fromJob.getId());
                    if (existingJob != null) {
                        existingJob.setEnabled(fromJob.isEnabled());
                        existingJob.setSettingsHash(fromJob.getSettingsHash());
                        continue;
                    }
                    ReplicationJob duplicatedFromJob = new ReplicationJob(fromJob);
                    duplicatedFromJob.setAsStopped();
                    this.replicationJobs.put(duplicatedFromJob.getId(), duplicatedFromJob);
                    this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
                }
                for (String replicationJobId : new HashSet<String>(this.replicationJobs.keySet())) {
                    if (fromReplicationJobs.getById(replicationJobId) != null) continue;
                    this.replicationJobs.remove(replicationJobId);
                    this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
                }
            }
        }
    }

    public void setReplicationJobStateToStopRequested(String replicationJobId) {
        LOGGER.debug("setReplicationJobStateToStopRequested replicationJobId={}", (Object)replicationJobId);
        ReplicationJob replicationJob = this.getById(replicationJobId);
        if (replicationJob != null) {
            replicationJob.setStateToStopRequested();
        }
    }

    public void setReplicationJobStateToStopped(String replicationJobId, String serverUUID) {
        LOGGER.debug("setReplicationJobStateToStopped replicationJobId={}, serverUUID={}", (Object)replicationJobId, (Object)serverUUID);
        ReplicationJob replicationJob = this.getById(replicationJobId);
        if (replicationJob != null) {
            replicationJob.setAsStopped();
        }
    }

    public void setReplicationJobStateToStartRequested(String replicationJobId, String serverUUID) {
        LOGGER.debug("setReplicationJobStateToStartRequested replicationJobId={}, serverUUID={}", (Object)replicationJobId, (Object)serverUUID);
        ReplicationJob replicationJob = this.getById(replicationJobId);
        if (replicationJob != null) {
            replicationJob.setStateToStartRequested(serverUUID);
        }
    }

    public void setReplicationJobStateToStarted(String replicationJobId, String serverUUID) {
        LOGGER.debug("setReplicationJobStateToStarted replicationJobId={}, serverUUID={}", (Object)replicationJobId, (Object)serverUUID);
        ReplicationJob replicationJob = this.getById(replicationJobId);
        if (replicationJob != null) {
            replicationJob.setAsRunningOnServer(serverUUID);
        }
    }

    @Override
    public Iterator<ReplicationJob> iterator() {
        return this.replicationJobs.values().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobs that = (ReplicationJobs)o;
        return this.lastModifiedTimestamp == that.lastModifiedTimestamp && Objects.equals(this.replicationJobs, that.replicationJobs);
    }

    public int hashCode() {
        return Objects.hash(this.replicationJobs, this.lastModifiedTimestamp);
    }

    public String toString() {
        return "ReplicationJobs{replicationJobs=" + this.replicationJobs + ", lastModifiedTimestamp=" + this.lastModifiedTimestamp + "}";
    }
}

