/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command.ds;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;

@Command(scope="jdbc", name="ds-factories", description="List the JDBC DataSourceFactories")
@Service
public class DSFactoriesCommand
extends JdbcCommandSupport {
    @Reference
    BundleContext context;
    private Comparator<DataSourceFactoryInfo> comparator = new DataSourceFactoryComparator();

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Class");
        table.column("Version");
        table.column("Registration bundle");
        TreeSet<DataSourceFactoryInfo> factories = new TreeSet<DataSourceFactoryInfo>(this.comparator);
        Collection refs = this.context.getServiceReferences(DataSourceFactory.class, null);
        for (ServiceReference ref : refs) {
            DataSourceFactoryInfo info = new DataSourceFactoryInfo();
            info.driverName = (String)ref.getProperty("osgi.jdbc.driver.name");
            info.driverClass = (String)ref.getProperty("osgi.jdbc.driver.class");
            info.driverVersion = (String)ref.getProperty("osgi.jdbc.driver.version");
            info.bundle = ref.getBundle() != null && ref.getBundle().getSymbolicName() != null ? String.format("%s [%s]", ref.getBundle().getSymbolicName(), ref.getBundle().getBundleId()) : "";
            factories.add(info);
        }
        for (DataSourceFactoryInfo info : factories) {
            table.addRow().addContent(new Object[]{info.driverName, info.driverClass, info.driverVersion, info.bundle});
        }
        table.print(System.out);
        return null;
    }

    private static class DataSourceFactoryInfo {
        public String driverName;
        public String driverClass;
        public String driverVersion;
        public String bundle;

        private DataSourceFactoryInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataSourceFactoryInfo that = (DataSourceFactoryInfo)o;
            return Objects.equals(this.driverName, that.driverName) && Objects.equals(this.driverClass, that.driverClass) && Objects.equals(this.driverVersion, that.driverVersion) && Objects.equals(this.bundle, that.bundle);
        }

        public int hashCode() {
            return Objects.hash(this.driverName, this.driverClass, this.driverVersion, this.bundle);
        }
    }

    private static class DataSourceFactoryComparator
    implements Comparator<DataSourceFactoryInfo> {
        private DataSourceFactoryComparator() {
        }

        @Override
        public int compare(DataSourceFactoryInfo dsf1, DataSourceFactoryInfo dsf2) {
            int r1 = 0;
            int r2 = 0;
            int r3 = 0;
            if (dsf1.bundle != null || dsf2.bundle != null) {
                r1 = dsf1.bundle == null ? -1 : (dsf2.bundle == null ? 1 : dsf1.bundle.compareTo(dsf2.bundle));
            }
            if (dsf1.driverName != null || dsf2.driverName != null) {
                r2 = dsf1.driverName == null ? -1 : (dsf2.driverName == null ? 1 : dsf1.driverName.compareTo(dsf2.driverName));
            }
            if (dsf1.driverClass != null || dsf2.driverClass != null) {
                r3 = dsf1.driverClass == null ? -1 : (dsf2.driverClass == null ? 1 : dsf1.driverClass.compareTo(dsf2.driverClass));
            }
            return r1 == 0 ? (r2 == 0 ? r3 : r2) : r1;
        }
    }
}

