/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;

public class ReplicationJobStartAcknowledgementWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "ReplicationJobStartedMessage:::";
    private final String jobId;
    private final String serverUUID;
    private final String transactionId;
    private final Instant sendedAtInUtc;

    public ReplicationJobStartAcknowledgementWebsocketMessage(String jobId, String serverUUID, String transactionId) {
        this(jobId, serverUUID, transactionId, TimestampUtil.nowInUtc());
    }

    public ReplicationJobStartAcknowledgementWebsocketMessage(String jobId, String serverUUID, String transactionId, Instant sendedAtInUtc) {
        this.jobId = jobId;
        this.serverUUID = serverUUID;
        this.transactionId = transactionId;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public ReplicationJobStartAcknowledgementWebsocketMessage(Map<String, Object> msgMap) {
        this(MapUtil.getValueAsString(msgMap, (String)"jobId", null), MapUtil.getValueAsString(msgMap, (String)"serverUUID", null), MapUtil.getValueAsString(msgMap, (String)"transactionId", null), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("jobId", "serverUUID", "transactionId", "sendedAt"));
    }

    private Map<String, Object> asMap() {
        return MapUtil.mapOf((Object[])new Object[]{"jobId", this.jobId, "serverUUID", this.serverUUID, "transactionId", this.transactionId, "sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc)});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static ReplicationJobStartAcknowledgementWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new ReplicationJobStartAcknowledgementWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + ReplicationJobStartAcknowledgementWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "ReplicationJobStartAcknowledgementWebsocketMessage{jobId='" + this.jobId + "', serverUUID='" + this.serverUUID + "', transactionId='" + this.transactionId + "', sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

