/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.start;

import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import de.virtimo.bpc.opensearch.plugin.transport.action.AggregatedNodesResponseException;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.start.BackupJobStartNodeResponse;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class BackupJobStartResponse
extends BaseNodesResponse<BackupJobStartNodeResponse>
implements ToXContentObject {
    public BackupJobStartResponse(StreamInput in) throws IOException {
        super(in);
    }

    public BackupJobStartResponse(ClusterName clusterName, List<BackupJobStartNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public List<BackupJobStartNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(BackupJobStartNodeResponse::new);
    }

    public void writeNodesTo(StreamOutput out, List<BackupJobStartNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (BackupJobStartNodeResponse nodeResponse : this.getNodes()) {
            BackupSnapshotInfoDTO backupSnapshotInfoFromBpcServerConnectedToANode = nodeResponse.getDto();
            if (backupSnapshotInfoFromBpcServerConnectedToANode == null) continue;
            return backupSnapshotInfoFromBpcServerConnectedToANode.toXContent(builder, params);
        }
        return null;
    }

    public OpenSearchException createAggregatedException() {
        return AggregatedNodesResponseException.create("Failed to start a backup job on nodes", this);
    }
}

