/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.collector.utils;

import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;

public class PropertiesPreparator {
    private static final String FIELDS_ADD = "fields.add.";
    private static final String FIELDS_RENAME = "fields.rename.";
    private static final String FIELDS_REMOVE = "fields.remove.";
    private static SimpleDateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    public static void prepare(Map<String, Object> data, Dictionary<String, Object> properties) throws Exception {
        String hostAddress;
        String karafName = (String)data.get("karafName");
        if (karafName == null && (karafName = System.getProperty("karaf.name")) != null) {
            data.put("karafName", karafName);
        }
        if ((hostAddress = (String)data.get("hostAddress")) == null) {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        data.put("hostAddress", hostAddress);
        String hostName = (String)data.get("hostName");
        if (hostName == null) {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        data.put("hostName", hostName);
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (key.startsWith(FIELDS_ADD)) {
                    if ("UUID".equals(properties.get(key).toString().trim())) {
                        String uuid = UUID.randomUUID().toString();
                        data.put(key.substring(FIELDS_ADD.length()), uuid);
                        continue;
                    }
                    if ("TIMESTAMP".equals(properties.get(key).toString().trim())) {
                        Date date = new Date();
                        data.put(key.substring(FIELDS_ADD.length()), tsFormat.format(date));
                        continue;
                    }
                    data.put(key.substring(FIELDS_ADD.length()), properties.get(key));
                    continue;
                }
                if (key.startsWith(FIELDS_RENAME)) {
                    if (!data.containsKey(key.substring(FIELDS_RENAME.length()))) continue;
                    Object value = data.get(key.substring(FIELDS_RENAME.length()));
                    data.remove(key.substring(FIELDS_RENAME.length()));
                    data.put(properties.get(key).toString().trim(), value);
                    continue;
                }
                if (key.startsWith(FIELDS_REMOVE)) {
                    if (!data.containsKey(key.substring(FIELDS_REMOVE.length()))) continue;
                    data.remove(key.substring(FIELDS_REMOVE.length()));
                    continue;
                }
                data.put(key, properties.get(key));
            }
        }
    }
}

