/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.WebSocket;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BpcConnections
implements OpenSearchPluginDTO {
    private static final Logger LOGGER = Loggers.getLogger(BpcConnections.class, (String[])new String[]{"os-bpc-plugin"});
    public static final long LAST_UPDATED_NOT_INITIALIZED = -1L;
    private final Set<BpcConnection> connections = new HashSet<BpcConnection>();
    private long lastUpdated = -1L;
    private static final Object CONNECTIONS_LOCK = new Object();

    public BpcConnections() {
    }

    public BpcConnections(Map<String, Object> connectionsMap) {
        this();
        this.checkForWellKnownKeys(connectionsMap);
        this.connections.addAll(MapUtil.getArrayValueAsListOfObjects(connectionsMap, (String)"entries", BpcConnection.class));
        this.lastUpdated = MapUtil.getValueAsLong(connectionsMap, (String)"lastUpdated", (long)-1L);
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("entries", "lastUpdated"));
    }

    public BpcConnections(StreamInput in) throws IOException {
        this();
        this.connections.addAll(in.readSet(BpcConnection::new));
        this.lastUpdated = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.connections);
        out.writeLong(this.lastUpdated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            builder.startObject();
            builder.field("lastUpdated", this.lastUpdated);
            builder.startArray("entries");
            for (BpcConnection connection : this.connections) {
                connection.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static BpcConnections fromXContent(XContentParser parser) throws IOException {
        return new BpcConnections(parser.map());
    }

    private void _keepNowAsLastUpdated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntries() {
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return !this.connections.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BpcConnection> getAll() {
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return new HashSet<BpcConnection>(this.connections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpcConnection addConnection(String nodeName, WebSocket webSocket) {
        LOGGER.debug("addConnection nodeName={}, webSocket={}", (Object)nodeName, (Object)webSocket);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            BpcConnection connection = new BpcConnection(nodeName, webSocket);
            this.connections.add(connection);
            this._keepNowAsLastUpdated();
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateConnection(BpcConnection connection) {
        LOGGER.debug("addOrUpdateConnection connection={}", (Object)connection);
        if (connection == null) {
            return;
        }
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            WebSocket existingWebSocket;
            BpcConnection existingConnection = this._getConnectionByWebsocketId(connection.getWebsocketId());
            if (existingConnection != null && connection.getWebSocket() == null && (existingWebSocket = existingConnection.getWebSocket()) != null) {
                connection.setWebSocket(existingWebSocket);
            }
            if (existingConnection != null) {
                this.connections.remove(existingConnection);
            }
            this.connections.add(connection);
            this._keepNowAsLastUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnection(BpcConnection connection) {
        LOGGER.debug("removeConnection connection={}", (Object)connection);
        if (connection == null) {
            return false;
        }
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            BpcConnection existingConnection = this._getConnectionByWebsocketId(connection.getWebsocketId());
            if (existingConnection != null) {
                boolean removed = this.connections.remove(existingConnection);
                if (removed) {
                    this._keepNowAsLastUpdated();
                }
                return removed;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBpcConnectionsSetting(Set<BpcConnection> bpcConnections) {
        LOGGER.debug("processBpcConnectionsSetting bpcConnections=...");
        if (bpcConnections == null) {
            return;
        }
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            HashMap<String, WebSocket> currentWebsocketConnections = new HashMap<String, WebSocket>();
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket = connection.getWebSocket();
                if (webSocket == null) continue;
                currentWebsocketConnections.put(webSocket.getId(), webSocket);
            }
            for (BpcConnection connection : bpcConnections) {
                if (!currentWebsocketConnections.containsKey(connection.getWebsocketId())) continue;
                connection.setWebSocket((WebSocket)currentWebsocketConnections.get(connection.getWebsocketId()));
            }
            this.connections.clear();
            this.connections.addAll(bpcConnections);
            this._keepNowAsLastUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BpcConnection> getConnectionsByOpenSearchNodeNames(Set<String> nodeNames) {
        LOGGER.debug("getConnectionsByOpenSearchNodeNames nodeNames={}", nodeNames);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            ArrayList<BpcConnection> result = new ArrayList<BpcConnection>();
            if (nodeNames != null && !nodeNames.isEmpty()) {
                for (BpcConnection connection : this.connections) {
                    if (!nodeNames.contains(connection.getConnectedNode())) continue;
                    result.add(connection);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpcConnection getConnectionByWebsocketId(String websocketId) {
        LOGGER.debug("getConnectionByWebsocketId websocketId={}", (Object)websocketId);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return this._getConnectionByWebsocketId(websocketId);
        }
    }

    private BpcConnection _getConnectionByWebsocketId(String websocketId) {
        LOGGER.debug("_getConnectionByWebsocketId websocketId={}", (Object)websocketId);
        if (!StringUtil.isNullOrEmpty((String)websocketId)) {
            for (BpcConnection connection : this.connections) {
                if (!connection.getWebsocketId().equals(websocketId)) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpcConnection getConnectionByServerUUID(String serverUUID) {
        LOGGER.debug("getConnectionByServerUUID serverUUID={}", (Object)serverUUID);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return this._getConnectionByServerUUID(serverUUID);
        }
    }

    private BpcConnection _getConnectionByServerUUID(String serverUUID) {
        LOGGER.debug("_getConnectionByServerUUID serverUUID={}", (Object)serverUUID);
        if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverStateInfo.getServerUUID().equals(serverUUID)) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerUUIDForWebsocketId(String websocketId) {
        LOGGER.debug("getServerUUIDForWebsocketId websocketId={}", (Object)websocketId);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            ServerStateInfoDTO serverStateInfo;
            BpcConnection connection = this._getConnectionByWebsocketId(websocketId);
            if (connection != null && (serverStateInfo = connection.getServerStateInfo()) != null) {
                return serverStateInfo.getServerUUID();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerStateInfoDTO getServerStateInfoByServerUUID(String serverUUID) {
        LOGGER.debug("getServerStateInfoByServerUUID serverUUID={}", (Object)serverUUID);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            BpcConnection connection = this._getConnectionByServerUUID(serverUUID);
            if (connection != null) {
                return connection.getServerStateInfo();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUUIDsOfServers() {
        LOGGER.debug("getUUIDsOfServers");
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            HashSet<String> serverUUIDs = new HashSet<String>();
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null) continue;
                serverUUIDs.add(serverStateInfo.getServerUUID());
            }
            return serverUUIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUUIDsOfServersThatCanBeUsedForReplication() {
        LOGGER.debug("getUUIDsOfServersThatCanBeUsedForReplication");
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            HashSet<String> serverUUIDs = new HashSet<String>();
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverStateInfo.canBeUsedForReplication()) continue;
                serverUUIDs.add(serverStateInfo.getServerUUID());
            }
            return serverUUIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerStateInfoDTO evaluateNextAvailableMasterServer() {
        LOGGER.debug("evaluateNextAvailableMasterServer");
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || serverStateInfo.isMaintenanceModeEnabled() || serverStateInfo.isMasterServer()) continue;
                return serverStateInfo;
            }
            return null;
        }
    }

    public void sendWebsocketMessage(WebsocketMessage websocketMessage, List<String> serverUUIDsToIgnore) {
        LOGGER.debug("sendWebsocketMessage websocketMessage={}, serverUUIDsToIgnore={}", (Object)websocketMessage, serverUUIDsToIgnore);
        this.sendWebsocketMessage(websocketMessage, serverUUIDsToIgnore, null, null);
    }

    private List<WebSocket> _collectRelatedWebSocketsForServerUUIDsToIgnore(List<String> serverUUIDsToIgnore) {
        LOGGER.debug("_collectRelatedWebSocketsForServerUUIDsToIgnore serverUUIDsToIgnore={}", serverUUIDsToIgnore);
        ArrayList<WebSocket> relatedWebSockets = new ArrayList<WebSocket>();
        for (BpcConnection connection : this.connections) {
            WebSocket webSocket;
            boolean webSocketCanBeUsed = false;
            if (serverUUIDsToIgnore == null) {
                webSocketCanBeUsed = true;
            } else {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverUUIDsToIgnore.contains(serverStateInfo.getServerUUID())) {
                    webSocketCanBeUsed = true;
                }
            }
            if (!webSocketCanBeUsed || (webSocket = connection.getWebSocket()) == null) continue;
            relatedWebSockets.add(webSocket);
        }
        return relatedWebSockets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWebsocketMessage(WebsocketMessage websocketMessage, List<String> serverUUIDsToIgnore, PreSendWebsocketMessagesCallback preSendWebsocketMessagesCallback, PostSendWebsocketMessagesCallback postSendWebsocketMessagesCallback) {
        LOGGER.debug("sendWebsocketMessage websocketMessage={}, serverUUIDsToIgnore={}, preSendWebsocketMessagesCallback={}, postSendWebsocketMessagesCallback={}", (Object)websocketMessage, serverUUIDsToIgnore, (Object)preSendWebsocketMessagesCallback, (Object)postSendWebsocketMessagesCallback);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            List<WebSocket> relatedWebSockets = this._collectRelatedWebSocketsForServerUUIDsToIgnore(serverUUIDsToIgnore);
            this.sendWebsocketMessage(relatedWebSockets, websocketMessage, preSendWebsocketMessagesCallback, postSendWebsocketMessagesCallback);
        }
    }

    public void sendWebsocketMessageToServerUUIDs(WebsocketMessage websocketMessage, List<String> serverUUIDs) {
        LOGGER.debug("sendWebsocketMessageToServerUUIDs websocketMessage={}, serverUUIDs={}", (Object)websocketMessage, serverUUIDs);
        this.sendWebsocketMessageToServerUUIDs(websocketMessage, serverUUIDs, null, null);
    }

    private List<WebSocket> _collectRelatedWebSocketsForServerUUIDs(List<String> serverUUIDs) {
        LOGGER.debug("_collectRelatedWebSocketsForServerUUIDs serverUUIDs={}", serverUUIDs);
        ArrayList<WebSocket> relatedWebSockets = new ArrayList<WebSocket>();
        for (BpcConnection connection : this.connections) {
            WebSocket webSocket;
            ServerStateInfoDTO serverStateInfo;
            boolean webSocketCanBeUsed = false;
            if (serverUUIDs != null && (serverStateInfo = connection.getServerStateInfo()) != null && serverUUIDs.contains(serverStateInfo.getServerUUID())) {
                webSocketCanBeUsed = true;
            }
            if (!webSocketCanBeUsed || (webSocket = connection.getWebSocket()) == null) continue;
            relatedWebSockets.add(webSocket);
        }
        return relatedWebSockets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWebsocketMessageToServerUUIDs(WebsocketMessage websocketMessage, List<String> serverUUIDs, PreSendWebsocketMessagesCallback preSendWebsocketMessagesCallback, PostSendWebsocketMessagesCallback postSendWebsocketMessagesCallback) {
        LOGGER.debug("sendWebsocketMessageToServerUUIDs websocketMessage={}, serverUUIDs={}, preSendWebsocketMessagesCallback={}, postSendWebsocketMessagesCallback={}", (Object)websocketMessage, serverUUIDs, (Object)preSendWebsocketMessagesCallback, (Object)postSendWebsocketMessagesCallback);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            List<WebSocket> relatedWebSockets = this._collectRelatedWebSocketsForServerUUIDs(serverUUIDs);
            this.sendWebsocketMessage(relatedWebSockets, websocketMessage, preSendWebsocketMessagesCallback, postSendWebsocketMessagesCallback);
        }
    }

    public void sendWebsocketMessageToServerUUID(WebsocketMessage websocketMessage, String serverUUID) {
        LOGGER.debug("sendWebsocketMessageToServerUUID websocketMessage={}, serverUUID={}", (Object)websocketMessage, (Object)serverUUID);
        if (websocketMessage == null || StringUtil.isNullOrEmpty((String)serverUUID)) {
            return;
        }
        this.sendWebsocketMessageToServerUUIDs(websocketMessage, Collections.singletonList(serverUUID));
    }

    private void sendWebsocketMessage(List<WebSocket> relatedWebSockets, final WebsocketMessage websocketMessage, PreSendWebsocketMessagesCallback preSendWebsocketMessagesCallback, PostSendWebsocketMessagesCallback postSendWebsocketMessagesCallback) {
        LOGGER.debug("sendWebsocketMessage relatedWebSockets=..., websocketMessage={}, preSendWebsocketMessagesCallback={}, postSendWebsocketMessagesCallback={}", (Object)websocketMessage, (Object)preSendWebsocketMessagesCallback, (Object)postSendWebsocketMessagesCallback);
        if (preSendWebsocketMessagesCallback != null) {
            preSendWebsocketMessagesCallback.goingToSendNumberOfWebsocketMessages(relatedWebSockets.size());
        }
        LOGGER.debug("Must send the message {} to {} websocket recipients.", (Object)websocketMessage, (Object)relatedWebSockets.size());
        final CountDownLatch numberOfSentWebsocketMessagesLatch = new CountDownLatch(relatedWebSockets.size());
        final WebsocketMessagesSentStatus status = new WebsocketMessagesSentStatus();
        for (WebSocket relatedWebSocket : relatedWebSockets) {
            relatedWebSocket.sendMessageAsync(websocketMessage, new ActionListener<Boolean>(){

                public void onResponse(Boolean aBoolean) {
                    status.increaseSuccessfullySent();
                    numberOfSentWebsocketMessagesLatch.countDown();
                }

                public void onFailure(Exception ex) {
                    LOGGER.error("Failed to send websocket message: {}", (Object)websocketMessage, (Object)ex);
                    status.increaseFailedToSent();
                    numberOfSentWebsocketMessagesLatch.countDown();
                }
            });
        }
        try {
            numberOfSentWebsocketMessagesLatch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.error("Failed to wait for all sent websocket messages.", (Throwable)ex);
        }
        if (postSendWebsocketMessagesCallback != null) {
            postSendWebsocketMessagesCallback.websocketMessagesSent(status.getSuccessfullySent(), status.getFailedToSent());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BpcConnections that = (BpcConnections)o;
        return this.lastUpdated == that.lastUpdated && Objects.equals(this.connections, that.connections);
    }

    public int hashCode() {
        return Objects.hash(this.connections, this.lastUpdated);
    }

    public String toString() {
        return "BpcConnections{connections=" + this.connections + ", lastUpdated=" + this.lastUpdated + "}";
    }

    @FunctionalInterface
    public static interface PreSendWebsocketMessagesCallback {
        public void goingToSendNumberOfWebsocketMessages(int var1);
    }

    @FunctionalInterface
    public static interface PostSendWebsocketMessagesCallback {
        public void websocketMessagesSent(int var1, int var2);
    }

    private static class WebsocketMessagesSentStatus {
        private int successfullySent = 0;
        private int failedToSent = 0;

        private WebsocketMessagesSentStatus() {
        }

        public void increaseSuccessfullySent() {
            ++this.successfullySent;
        }

        public int getSuccessfullySent() {
            return this.successfullySent;
        }

        public void increaseFailedToSent() {
            ++this.failedToSent;
        }

        public int getFailedToSent() {
            return this.failedToSent;
        }
    }
}

