/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.servers;

import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.MasterServerInfo;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import de.virtimo.bpc.opensearch.plugin.rest.action.RequestParamMissingException;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

public class RestSetMasterServerAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOGGER = Loggers.getLogger(RestSetMasterServerAction.class, (String[])new String[]{"os-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_bpc/servers/master"));
    }

    public String getName() {
        return "set_master_server_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException, RequestParamMissingException {
        LOGGER.debug("prepareRequest request={}, nodeClient={}, manager={}", (Object)request, (Object)nodeClient, (Object)manager);
        String serverUUID = this.getMandatoryQueryParamAsString(request, "serverUUID");
        LOGGER.debug("serverUUID={}", (Object)serverUUID);
        return channel -> {
            ServerStateInfoDTO serverStateInfo = manager.getConnections().getServerStateInfoByServerUUID(serverUUID);
            if (serverStateInfo == null) {
                this.sendNotFound((RestChannel)channel, "Did not found a server with the UUID '" + serverUUID + "'.");
            } else if (serverStateInfo.isMaintenanceModeEnabled()) {
                this.sendBadRequest((RestChannel)channel, "The server with the UUID '" + serverUUID + "' is in maintenance and cannot be set as master server.");
            } else if (serverStateInfo.isMasterServer()) {
                this.sendOK((RestChannel)channel, "The server with the UUID '" + serverUUID + "' is already the master server.");
            } else {
                manager.setAsMasterServer(serverUUID, new ActionListener<MasterServerInfo>(){

                    public void onResponse(MasterServerInfo masterServerInfo) {
                        RestSetMasterServerAction.this.sendOK(channel);
                    }

                    public void onFailure(Exception ex) {
                        RestSetMasterServerAction.this.sendError(channel, ex);
                    }
                });
            }
        };
    }
}

