/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class BroadcastToAllExceptSenderWebsocketMessage
implements WebsocketMessage,
Writeable {
    private static final String PREFIX = "[BROADCAST_TO_ALL_EXCEPT_SENDER]";
    private final String message;

    public BroadcastToAllExceptSenderWebsocketMessage(String message) {
        Objects.requireNonNull(message, "'message' must not be null");
        this.message = message;
    }

    public BroadcastToAllExceptSenderWebsocketMessage(WebsocketMessage websocketMessageToBroadcast) throws WebsocketMessageException {
        Objects.requireNonNull(websocketMessageToBroadcast, "'websocketMessageToBroadcast' must not be null");
        this.message = websocketMessageToBroadcast.getMessageToSend();
    }

    public BroadcastToAllExceptSenderWebsocketMessage(StreamInput in) throws IOException {
        this.message = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.message);
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BroadcastToAllExceptSenderWebsocketMessage createFromMessage(String websocketMessage) {
        String message = websocketMessage.substring(PREFIX.length());
        return new BroadcastToAllExceptSenderWebsocketMessage(message);
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        return PREFIX + this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastToAllExceptSenderWebsocketMessage that = (BroadcastToAllExceptSenderWebsocketMessage)o;
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public String toString() {
        return "BroadcastToAllExceptSenderWebsocketMessage{message='" + this.message + "'}";
    }
}

