/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InputOutput {
    private ImmutableList<String> lines = ImmutableList.of();
    protected static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    private static final DiscreteDomain<Integer> INTEGERS = DiscreteDomain.integers();
    protected final List<Range<Integer>> ranges = new ArrayList<Range<Integer>>();

    protected final void setLines(ImmutableList<String> lines) {
        this.lines = lines;
    }

    public final int getLineCount() {
        return this.lines.size();
    }

    public final String getLine(int lineI) {
        return (String)this.lines.get(lineI);
    }

    private static void addToRanges(List<Range<Integer>> ranges, int i, int k) {
        while (ranges.size() <= i) {
            ranges.add(EMPTY_RANGE);
        }
        Range<Integer> oldValue = ranges.get(i);
        ranges.set(i, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(oldValue.isEmpty() ? k : (Integer)oldValue.lowerEndpoint()), (Comparable)Integer.valueOf(k + 1)));
    }

    protected final void computeRanges(List<? extends Input.Tok> toks) {
        int lineI = 0;
        for (Input.Tok tok : toks) {
            String txt = tok.getOriginalText();
            int lineI0 = lineI;
            lineI += Newlines.count(txt);
            int k = tok.getIndex();
            if (k < 0) continue;
            for (int i = lineI0; i <= lineI; ++i) {
                InputOutput.addToRanges(this.ranges, i, k);
            }
        }
    }

    public static Map<Integer, Range<Integer>> makeKToIJ(InputOutput put) {
        HashMap<Integer, Range<Integer>> map = new HashMap<Integer, Range<Integer>>();
        int ijN = put.getLineCount();
        for (int ij = 0; ij <= ijN; ++ij) {
            Range range = put.getRanges(ij).canonical(INTEGERS);
            for (int k = ((Integer)range.lowerEndpoint()).intValue(); k < (Integer)range.upperEndpoint(); ++k) {
                if (map.containsKey(k)) {
                    map.put(k, (Range<Integer>)Range.closedOpen((Comparable)((Integer)((Range)map.get(k)).lowerEndpoint()), (Comparable)Integer.valueOf(ij + 1)));
                    continue;
                }
                map.put(k, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(ij), (Comparable)Integer.valueOf(ij + 1)));
            }
        }
        return map;
    }

    public final Range<Integer> getRanges(int lineI) {
        return 0 <= lineI && lineI < this.ranges.size() ? this.ranges.get(lineI) : EMPTY_RANGE;
    }

    public String toString() {
        return "InputOutput{lines=" + String.valueOf(this.lines) + ", ranges=" + String.valueOf(this.ranges) + "}";
    }
}

