/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BackupJobScheduleActionEntryDTO
implements OpenSearchPluginDTO {
    private final String backupJobIdentifier;
    private final Map<String, Object> backupSetting;

    public BackupJobScheduleActionEntryDTO(String backupJobIdentifier, Map<String, Object> backupSetting) {
        Objects.requireNonNull(backupJobIdentifier, "backupJobIdentifier cannot be null");
        Objects.requireNonNull(backupSetting, "backupSetting cannot be null");
        this.backupJobIdentifier = backupJobIdentifier;
        this.backupSetting = backupSetting;
    }

    public BackupJobScheduleActionEntryDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"backupJobIdentifier", null), MapUtil.getValueAsMap(actionMap, (String)"backupSetting", null));
        this.checkForWellKnownKeys(actionMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> actionMap) {
        MapUtil.checkForWellKnownKeys(actionMap, Set.of("backupJobIdentifier", "backupSetting"));
    }

    public BackupJobScheduleActionEntryDTO(StreamInput in) throws IOException {
        this.backupJobIdentifier = in.readString();
        this.backupSetting = in.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.backupJobIdentifier);
        out.writeMap(this.backupSetting);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("backupJobIdentifier", this.backupJobIdentifier);
        builder.field("backupSetting", this.backupSetting);
        builder.endObject();
        return builder;
    }

    public BackupJobScheduleActionEntryDTO fromXContent(XContentParser parser) throws IOException {
        return new BackupJobScheduleActionEntryDTO(parser.map());
    }

    public String getBackupJobIdentifier() {
        return this.backupJobIdentifier;
    }

    public Map<String, Object> getBackupSetting() {
        return this.backupSetting;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobScheduleActionEntryDTO that = (BackupJobScheduleActionEntryDTO)o;
        return Objects.equals(this.backupJobIdentifier, that.backupJobIdentifier) && Objects.equals(this.backupSetting, that.backupSetting);
    }

    public int hashCode() {
        return Objects.hash(this.backupJobIdentifier, this.backupSetting);
    }

    public String toString() {
        return "BackupJobScheduleActionEntryDTO{backupJobIdentifier='" + this.backupJobIdentifier + "', backupSetting=" + String.valueOf(this.backupSetting) + "}";
    }
}

