/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.LoadedModuleDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class LoadedModulesDTO
implements Iterable<LoadedModuleDTO>,
OpenSearchPluginDTO {
    private final List<LoadedModuleDTO> loadedModules = new ArrayList<LoadedModuleDTO>();

    public LoadedModulesDTO() {
    }

    public LoadedModulesDTO(List<Map<String, Object>> loadedModulesList) {
        this();
        if (loadedModulesList != null) {
            for (Map<String, Object> loadedModuleAsMap : loadedModulesList) {
                LoadedModuleDTO loadedModule = new LoadedModuleDTO(loadedModuleAsMap);
                this.loadedModules.add(loadedModule);
            }
        }
    }

    public LoadedModulesDTO(StreamInput in) throws IOException {
        this();
        this.loadedModules.addAll(in.readList(LoadedModuleDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.loadedModules);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (LoadedModuleDTO loadedModule : this.loadedModules) {
            loadedModule.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public boolean isEmpty() {
        return this.loadedModules.isEmpty();
    }

    public int size() {
        return this.loadedModules.size();
    }

    public LoadedModuleDTO get(int index) {
        return this.loadedModules.get(index);
    }

    public List<LoadedModuleDTO> getLoadedModules() {
        return new ArrayList<LoadedModuleDTO>(this.loadedModules);
    }

    public boolean hasModuleLoaded(String moduleId) {
        return this.getLoadedModule(moduleId) != null;
    }

    public LoadedModuleDTO getLoadedModule(String moduleId) {
        for (LoadedModuleDTO loadedModule : this.loadedModules) {
            if (!loadedModule.getId().equals(moduleId)) continue;
            return loadedModule;
        }
        return null;
    }

    public void addLoadedModule(LoadedModuleDTO loadedModule) {
        if (!this.hasModuleLoaded(loadedModule.getId())) {
            this.loadedModules.add(loadedModule);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadedModulesDTO that = (LoadedModulesDTO)o;
        if (this.loadedModules == null && that.loadedModules == null) {
            return true;
        }
        if (this.loadedModules == null && that.loadedModules != null) {
            return false;
        }
        if (this.loadedModules != null && that.loadedModules == null) {
            return false;
        }
        return this.loadedModules.containsAll(that.loadedModules) && that.loadedModules.containsAll(this.loadedModules);
    }

    public int hashCode() {
        return Objects.hash(this.loadedModules);
    }

    @Override
    public Iterator<LoadedModuleDTO> iterator() {
        return this.loadedModules.iterator();
    }

    public String toString() {
        return "LoadedModulesDTO{loadedModules=" + String.valueOf(this.loadedModules) + "}";
    }
}

