/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.utils;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class JsonUtil {
    public static String asJsonString(ToXContent toXContentImpl) throws IOException {
        if (toXContentImpl != null) {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            toXContentImpl.toXContent(jsonBuilder, null);
            return jsonBuilder.toString();
        }
        return null;
    }

    public static String asJsonString(Map<String, Object> map) throws IOException {
        if (map != null) {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            jsonBuilder.map(map);
            return jsonBuilder.toString();
        }
        return null;
    }

    public static Map<String, Object> asMap(String jsonString) throws IOException {
        if (jsonString != null) {
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonString);){
                Map map = parser.map();
                return map;
            }
        }
        return null;
    }

    public static Map<String, Object> asMap(BytesReference bytesReference) throws IOException {
        if (bytesReference != null) {
            try (StreamInput bytesReferenceInputStream = bytesReference.streamInput();){
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)bytesReferenceInputStream);
                Map map = parser.map();
                return map;
            }
        }
        return null;
    }

    public static Map<String, Object> asMap(ToXContent toXContentImpl) throws IOException {
        if (toXContentImpl != null) {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            toXContentImpl.toXContent(jsonBuilder, null);
            return JsonUtil.asMap(BytesReference.bytes((XContentBuilder)jsonBuilder));
        }
        return null;
    }

    public static List<Object> asList(String jsonString) throws IOException {
        if (!StringUtil.isNullOrEmpty(jsonString)) {
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonString);){
                List list = parser.list();
                return list;
            }
        }
        return null;
    }

    public static List<Object> asList(BytesReference bytesReference) throws IOException {
        if (bytesReference != null) {
            try (StreamInput bytesReferenceInputStream = bytesReference.streamInput();){
                List list;
                block13: {
                    XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)bytesReferenceInputStream);
                    try {
                        list = parser.list();
                        if (parser == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return list;
            }
        }
        return null;
    }

    public static List<Object> asList(XContentBuilder jsonBuilder) throws IOException {
        if (jsonBuilder != null) {
            return JsonUtil.asList(BytesReference.bytes((XContentBuilder)jsonBuilder));
        }
        return null;
    }

    public static List<Map<String, Object>> asListOfMaps(String jsonString) throws IOException {
        return JsonUtil.castToListOfMaps(JsonUtil.asList(jsonString));
    }

    private static List<Map<String, Object>> asListOfMaps(BytesReference bytesReference) throws IOException {
        if (bytesReference != null) {
            return JsonUtil.castToListOfMaps(JsonUtil.asList(bytesReference));
        }
        return null;
    }

    public static List<Map<String, Object>> asListOfMaps(ToXContent toXContentImpl) throws IOException {
        if (toXContentImpl != null) {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            toXContentImpl.toXContent(jsonBuilder, null);
            return JsonUtil.asListOfMaps(BytesReference.bytes((XContentBuilder)jsonBuilder));
        }
        return null;
    }

    public static List<Map<String, Object>> asListOfMaps(XContentBuilder jsonBuilder) throws IOException {
        if (jsonBuilder != null) {
            return JsonUtil.castToListOfMaps(JsonUtil.asList(jsonBuilder));
        }
        return null;
    }

    private static List<Map<String, Object>> castToListOfMaps(List<Object> listOfObjects) {
        ArrayList<Map> result = null;
        if (listOfObjects != null) {
            for (Object object : listOfObjects) {
                if (!(object instanceof Map)) continue;
                if (result == null) {
                    result = new ArrayList<Map>();
                }
                result.add((Map)object);
            }
        }
        return result;
    }
}

