/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.utils;

import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapUtil {
    public static Map<String, Object> mapOf(Object ... keyValuePairs) throws IllegalArgumentException {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("keyValuePairs must be given as pairs of 2");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object key = keyValuePairs[i];
            Object value = keyValuePairs[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Keys must be of type String");
            }
            result.put((String)key, value);
        }
        return result;
    }

    public static boolean exists(Map<String, Object> dataMap, String key) {
        return dataMap != null && key != null && dataMap.containsKey(key);
    }

    public static Map<String, Object> getEntriesWithKeyPrefix(Map<String, Object> map, String keyPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
            if (!stringObjectEntry.getKey().startsWith(keyPrefix)) continue;
            result.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        return result;
    }

    public static byte getValueAsByte(Map dataMap, String key, byte defaultValue) {
        block6: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Byte)value;
                }
                catch (Exception e) {
                    if (value instanceof Integer) {
                        return ((Integer)value).byteValue();
                    }
                    if (!(value instanceof String)) break block6;
                    try {
                        return Byte.parseByte((String)value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return defaultValue;
    }

    public static int getValueAsInt(Map dataMap, String key, int defaultValue) {
        block5: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Integer)value;
                }
                catch (Exception e) {
                    if (!(value instanceof String)) break block5;
                    try {
                        return Integer.parseInt((String)value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return defaultValue;
    }

    public static Integer getValueAsInteger(Map dataMap, String key, Integer defaultValue) {
        block5: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Integer)value;
                }
                catch (Exception e) {
                    if (!(value instanceof String)) break block5;
                    try {
                        return Integer.parseInt((String)value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return defaultValue;
    }

    public static long getValueAsLong(Map dataMap, String key, long defaultValue) {
        block6: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Long)value;
                }
                catch (Exception e) {
                    if (value instanceof String) {
                        try {
                            return Long.parseLong((String)value);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    if (!(value instanceof Integer)) break block6;
                    return ((Integer)value).longValue();
                }
            }
        }
        return defaultValue;
    }

    public static boolean getValueAsBoolean(Map dataMap, String key, boolean defaultValue) {
        block5: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Boolean)value;
                }
                catch (Exception e) {
                    if (!(value instanceof String)) break block5;
                    try {
                        return Boolean.parseBoolean((String)value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return defaultValue;
    }

    public static String getValueAsString(Map dataMap, String key, String defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
            try {
                return (String)dataMap.get(key);
            }
            catch (Exception e) {
                try {
                    return String.valueOf(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public static String[] getValueAsStringArray(Map dataMap, String key, String[] defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null && value instanceof List) {
            try {
                return ((List)value).toArray(new String[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static List getValueAsList(Map dataMap, String key, List defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null && value instanceof List) {
            return (List)value;
        }
        return defaultValue;
    }

    public static Set getValueAsSet(Map dataMap, String key, Set defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
            if (value instanceof Set) {
                return (Set)value;
            }
            if (value instanceof List) {
                return new HashSet((List)value);
            }
        }
        return defaultValue;
    }

    public static Map getValueAsMap(Map dataMap, String key, Map defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null && value instanceof Map) {
            return (Map)value;
        }
        return defaultValue;
    }

    public static Object getValueAsObject(Map dataMap, String key, Object defaultValue) {
        if (dataMap != null && key != null) {
            return dataMap.get(key);
        }
        return defaultValue;
    }

    public static Instant getValueAsInstant(Map dataMap, String key, Instant defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
            if (value instanceof Instant) {
                return (Instant)value;
            }
            if (value instanceof String) {
                return TimestampUtil.parseAsInstant((String)value);
            }
        }
        return defaultValue;
    }

    public static <T> List<T> getArrayValueAsListOfObjects(Map dataMap, String key, Class<T> objectClass) {
        Objects.requireNonNull(dataMap, "'dataMap' must not be null");
        Objects.requireNonNull(key, "'key' must not be null");
        Objects.requireNonNull(objectClass, "'objectClass' must not be null");
        ArrayList result = new ArrayList();
        MapUtil.addArrayValuesToCollection(result, dataMap, key, objectClass);
        return result;
    }

    public static <T> Set<T> getArrayValueAsSetOfObjects(Map dataMap, String key, Class<T> objectClass) {
        Objects.requireNonNull(dataMap, "'dataMap' must not be null");
        Objects.requireNonNull(key, "'key' must not be null");
        Objects.requireNonNull(objectClass, "'objectClass' must not be null");
        HashSet result = new HashSet();
        MapUtil.addArrayValuesToCollection(result, dataMap, key, objectClass);
        return result;
    }

    private static <T> void addArrayValuesToCollection(Collection<T> result, Map dataMap, String key, Class<T> objectClass) {
        List valueAsList = MapUtil.getValueAsList(dataMap, key, null);
        if (valueAsList == null || valueAsList.isEmpty()) {
            return;
        }
        Constructor<Map<String, Object>> classConstructor = MapUtil.findMapConstructor(objectClass);
        if (classConstructor == null) {
            throw new IllegalArgumentException("The provided class '" + objectClass.getSimpleName() + "' does not have the required Map<String, Object> constructor.");
        }
        for (Object listEntry : valueAsList) {
            if (!(listEntry instanceof Map)) continue;
            try {
                Map<String, Object> createdInstance = classConstructor.newInstance(listEntry);
                result.add(createdInstance);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Failed to create an instance of the provided class '" + objectClass.getSimpleName() + "'.", ex);
            }
        }
    }

    public static Constructor<Map<String, Object>> findMapConstructor(Class<?> clazz) {
        Objects.requireNonNull(clazz, "'clazz' must not be null");
        for (Constructor<Map<String, Object>> constructor : clazz.getConstructors()) {
            ParameterizedType parameterizedArg;
            Type[] parameterTypes = constructor.getGenericParameterTypes();
            if (parameterTypes.length != 1 || !(parameterTypes[0] instanceof ParameterizedType) || (parameterizedArg = (ParameterizedType)parameterTypes[0]).getRawType() != Map.class || parameterizedArg.getActualTypeArguments()[0] != String.class || parameterizedArg.getActualTypeArguments()[1] != Object.class) continue;
            return constructor;
        }
        return null;
    }

    public static void checkForWellKnownKeys(Map<String, Object> map, Set<String> wellKnownKeys) {
        if (map != null && wellKnownKeys != null) {
            for (String key : map.keySet()) {
                if (wellKnownKeys.contains(key)) continue;
                throw new IllegalArgumentException("Invalid key '" + key + "' used in the provided map " + String.valueOf(map) + ".");
            }
        }
    }
}

