/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class LoadedModuleDTO
implements OpenSearchPluginDTO {
    private final String id;
    private final String version;

    public LoadedModuleDTO(String id, String version) {
        Objects.requireNonNull(id, "id must not be null");
        this.id = id;
        this.version = version;
    }

    public LoadedModuleDTO(Map<String, Object> moduleData) {
        this(MapUtil.getValueAsString(moduleData, (String)"id", null), MapUtil.getValueAsString(moduleData, (String)"version", null));
        this.checkForWellKnownKeys(moduleData);
    }

    private void checkForWellKnownKeys(Map<String, Object> moduleData) {
        MapUtil.checkForWellKnownKeys(moduleData, Set.of("id", "version"));
    }

    public LoadedModuleDTO(StreamInput in) throws IOException {
        this.id = in.readString();
        this.version = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("version", this.version);
        builder.endObject();
        return builder;
    }

    public static LoadedModuleDTO fromXContent(XContentParser parser) throws IOException {
        return new LoadedModuleDTO(parser.map());
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadedModuleDTO that = (LoadedModuleDTO)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public String toString() {
        return "LoadedModuleDTO{id='" + this.id + "', version='" + this.version + "'}";
    }
}

