/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.query;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.module.monitor.query.SessionBasedQuery;
import de.virtimo.bpc.module.monitor.query.ViewQuery;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class DateRangeQuery {
    private static final Logger LOGGER = LogManager.getLogger(DateRangeQuery.class);

    public static QueryBuilder getQueryBuilder(String view, String startDate, String endDate, String timeseriesColumn, UserSession userSession, String timeZoneId, ModuleInstance mi, Map<String, Object> dataFilterSetting, String dataFilterOperator) throws IOException {
        LOGGER.info("getQueryBuilder view={}, startDate={}, endDate={}, timeseriesColumn={}, userSession=..., timeZoneId={}, mi=..., dataFilterSetting=...", (Object)view, (Object)startDate, (Object)endDate, (Object)timeseriesColumn, (Object)timeZoneId);
        QueryBuilder query = new BpcQueryBuilder().addQueryBuilder(SessionBasedQuery.getQueryBuilder(userSession, dataFilterSetting, dataFilterOperator)).addDateRangeQuery(timeseriesColumn, startDate, endDate, timeZoneId).addSkipPercolatorDocumentsQuery().buildAsBoolFilterQuery();
        QueryBuilder viewQuery = ViewQuery.getQueryBuilder(mi, view, userSession);
        if (viewQuery != null) {
            return QueryBuilders.boolQuery().must(query).must(viewQuery);
        }
        return query;
    }
}

