/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.query;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.module.monitor.query.SessionBasedQuery;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilder;

public class ViewQuery {
    private static final Logger LOGGER = LogManager.getLogger(ViewQuery.class);

    public static QueryBuilder getQueryBuilder(ModuleInstance mi, String view, UserSession userSession) {
        block7: {
            LOGGER.info("getQueryBuilder mi=..., view=..., userSession=...");
            if (view != null && !view.isEmpty()) {
                LOGGER.info("Check viewConfig for view {}", (Object)view);
                try {
                    Map multiViewConfig = (Map)mi.getConfiguration().getSetting("function_gridMultipleViewsConfig").getValue();
                    if (multiViewConfig == null) {
                        throw new NullPointerException("The JSON value of the monitor instance (" + String.valueOf(mi) + ") setting 'function_gridMultipleViewsConfig' must not be null.");
                    }
                    if (!multiViewConfig.containsKey("views")) break block7;
                    LOGGER.info("Config found");
                    List viewList = (List)multiViewConfig.get("views");
                    if (viewList == null) break block7;
                    for (Map viewConfig : viewList) {
                        if (!viewConfig.containsKey("id") || !((String)viewConfig.get("id")).equalsIgnoreCase(view)) continue;
                        if (viewConfig.containsKey("filter")) {
                            Map filterMap = (Map)viewConfig.get("filter");
                            if (!filterMap.isEmpty()) {
                                LOGGER.info("Add view filter");
                                return SessionBasedQuery.getQueryForMap(filterMap, userSession);
                            }
                            LOGGER.info("Ignore empty filter");
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }
}

